package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleContent,
  ApprovalRuleId,
  ApprovalRuleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApprovalRuleEventMetadata(
    approvalRuleName: Option[ApprovalRuleName] = None,
    approvalRuleId: Option[ApprovalRuleId] = None,
    approvalRuleContent: Option[ApprovalRuleContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata = {
    import ApprovalRuleEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
      .builder()
      .optionallyWith(
        approvalRuleName.map(value =>
          ApprovalRuleName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleName)
      .optionallyWith(
        approvalRuleId.map(value =>
          ApprovalRuleId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleId)
      .optionallyWith(
        approvalRuleContent.map(value =>
          ApprovalRuleContent.unwrap(value): java.lang.String
        )
      )(_.approvalRuleContent)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly =
    zio.aws.codecommit.model.ApprovalRuleEventMetadata.wrap(buildAwsValue())
}
object ApprovalRuleEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalRuleEventMetadata =
      zio.aws.codecommit.model.ApprovalRuleEventMetadata(
        approvalRuleName.map(value => value),
        approvalRuleId.map(value => value),
        approvalRuleContent.map(value => value)
      )
    def approvalRuleName: Option[ApprovalRuleName]
    def approvalRuleId: Option[ApprovalRuleId]
    def approvalRuleContent: Option[ApprovalRuleContent]
    def getApprovalRuleName: ZIO[Any, AwsError, ApprovalRuleName] =
      AwsError.unwrapOptionField("approvalRuleName", approvalRuleName)
    def getApprovalRuleId: ZIO[Any, AwsError, ApprovalRuleId] =
      AwsError.unwrapOptionField("approvalRuleId", approvalRuleId)
    def getApprovalRuleContent: ZIO[Any, AwsError, ApprovalRuleContent] =
      AwsError.unwrapOptionField("approvalRuleContent", approvalRuleContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ) extends zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly {
    override val approvalRuleName: Option[ApprovalRuleName] = scala
      .Option(impl.approvalRuleName())
      .map(value => zio.aws.codecommit.model.primitives.ApprovalRuleName(value))
    override val approvalRuleId: Option[ApprovalRuleId] = scala
      .Option(impl.approvalRuleId())
      .map(value => zio.aws.codecommit.model.primitives.ApprovalRuleId(value))
    override val approvalRuleContent: Option[ApprovalRuleContent] = scala
      .Option(impl.approvalRuleContent())
      .map(value =>
        zio.aws.codecommit.model.primitives.ApprovalRuleContent(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ): zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly = new Wrapper(
    impl
  )
}
