package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RevisionId, Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileVersion(
    commit: Optional[zio.aws.codecommit.model.Commit] = Optional.Absent,
    blobId: Optional[ObjectId] = Optional.Absent,
    path: Optional[Path] = Optional.Absent,
    revisionChildren: Optional[Iterable[RevisionId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.FileVersion = {
    import FileVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.FileVersion
      .builder()
      .optionallyWith(commit.map(value => value.buildAwsValue()))(_.commit)
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(
        revisionChildren.map(value =>
          value.map { item =>
            RevisionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.revisionChildren)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.FileVersion.ReadOnly =
    zio.aws.codecommit.model.FileVersion.wrap(buildAwsValue())
}
object FileVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.FileVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.FileVersion =
      zio.aws.codecommit.model.FileVersion(
        commit.map(value => value.asEditable),
        blobId.map(value => value),
        path.map(value => value),
        revisionChildren.map(value => value)
      )
    def commit: Optional[zio.aws.codecommit.model.Commit.ReadOnly]
    def blobId: Optional[ObjectId]
    def path: Optional[Path]
    def revisionChildren: Optional[List[RevisionId]]
    def getCommit
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Commit.ReadOnly] =
      AwsError.unwrapOptionField("commit", commit)
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getRevisionChildren: ZIO[Any, AwsError, List[RevisionId]] =
      AwsError.unwrapOptionField("revisionChildren", revisionChildren)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.FileVersion
  ) extends zio.aws.codecommit.model.FileVersion.ReadOnly {
    override val commit: Optional[zio.aws.codecommit.model.Commit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commit())
        .map(value => zio.aws.codecommit.model.Commit.wrap(value))
    override val blobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val path: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val revisionChildren: Optional[List[RevisionId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionChildren())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.RevisionId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.FileVersion
  ): zio.aws.codecommit.model.FileVersion.ReadOnly = new Wrapper(impl)
}
