package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ErrorMessage,
  ErrorCode,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateApprovalRuleTemplateFromRepositoriesError(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError = {
    import BatchDisassociateApprovalRuleTemplateFromRepositoriesError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly =
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
      .wrap(buildAwsValue())
}
object BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError =
      zio.aws.codecommit.model
        .BatchDisassociateApprovalRuleTemplateFromRepositoriesError(
          repositoryName.map(value => value),
          errorCode.map(value => value),
          errorMessage.map(value => value)
        )
    def repositoryName: Optional[RepositoryName]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ) extends zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.codecommit.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.codecommit.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ): zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly =
    new Wrapper(impl)
}
