package zio.aws.codecommit.model
import scala.jdk.CollectionConverters._
sealed trait ChangeTypeEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum
}
object ChangeTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum
  ): zio.aws.codecommit.model.ChangeTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.A =>
      val r = A
      r
    case software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.M =>
      val r = M
      r
    case software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.D =>
      val r = D
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.ChangeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object A extends zio.aws.codecommit.model.ChangeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.A
  }
  case object M extends zio.aws.codecommit.model.ChangeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.M
  }
  case object D extends zio.aws.codecommit.model.ChangeTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum.D
  }
}
