package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitId, BranchName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BranchInfo(
    branchName: Optional[BranchName] = Optional.Absent,
    commitId: Optional[CommitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BranchInfo = {
    import BranchInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BranchInfo
      .builder()
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .optionallyWith(
        commitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.commitId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BranchInfo.ReadOnly =
    zio.aws.codecommit.model.BranchInfo.wrap(buildAwsValue())
}
object BranchInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BranchInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BranchInfo =
      zio.aws.codecommit.model.BranchInfo(
        branchName.map(value => value),
        commitId.map(value => value)
      )
    def branchName: Optional[BranchName]
    def commitId: Optional[CommitId]
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("commitId", commitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BranchInfo
  ) extends zio.aws.codecommit.model.BranchInfo.ReadOnly {
    override val branchName: Optional[BranchName] = zio.aws.core.internal
      .optionalFromNullable(impl.branchName())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
    override val commitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BranchInfo
  ): zio.aws.codecommit.model.BranchInfo.ReadOnly = new Wrapper(impl)
}
