package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  FileContent,
  ObjectSize,
  Path,
  ObjectId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFileResponse(
    commitId: ObjectId,
    blobId: ObjectId,
    filePath: Path,
    fileMode: zio.aws.codecommit.model.FileModeTypeEnum,
    fileSize: ObjectSize,
    fileContent: FileContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetFileResponse = {
    import GetFileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetFileResponse
      .builder()
      .commitId(ObjectId.unwrap(commitId): java.lang.String)
      .blobId(ObjectId.unwrap(blobId): java.lang.String)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .fileMode(fileMode.unwrap)
      .fileSize(ObjectSize.unwrap(fileSize): java.lang.Long)
      .fileContent(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(fileContent.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetFileResponse.ReadOnly =
    zio.aws.codecommit.model.GetFileResponse.wrap(buildAwsValue())
}
object GetFileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetFileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetFileResponse =
      zio.aws.codecommit.model.GetFileResponse(
        commitId,
        blobId,
        filePath,
        fileMode,
        fileSize,
        fileContent
      )
    def commitId: ObjectId
    def blobId: ObjectId
    def filePath: Path
    def fileMode: zio.aws.codecommit.model.FileModeTypeEnum
    def fileSize: ObjectSize
    def fileContent: FileContent
    def getCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(commitId)
    def getBlobId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(blobId)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getFileMode
        : ZIO[Any, Nothing, zio.aws.codecommit.model.FileModeTypeEnum] =
      ZIO.succeed(fileMode)
    def getFileSize: ZIO[Any, Nothing, ObjectSize] = ZIO.succeed(fileSize)
    def getFileContent: ZIO[Any, Nothing, FileContent] =
      ZIO.succeed(fileContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetFileResponse
  ) extends zio.aws.codecommit.model.GetFileResponse.ReadOnly {
    override val commitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.commitId())
    override val blobId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.blobId())
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val fileMode: zio.aws.codecommit.model.FileModeTypeEnum =
      zio.aws.codecommit.model.FileModeTypeEnum.wrap(impl.fileMode())
    override val fileSize: ObjectSize =
      zio.aws.codecommit.model.primitives.ObjectSize(impl.fileSize())
    override val fileContent: FileContent = zio.aws.codecommit.model.primitives
      .FileContent(zio.Chunk.fromArray(impl.fileContent().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetFileResponse
  ): zio.aws.codecommit.model.GetFileResponse.ReadOnly = new Wrapper(impl)
}
