package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMergeOptionsResponse(
    mergeOptions: Iterable[zio.aws.codecommit.model.MergeOptionTypeEnum],
    sourceCommitId: ObjectId,
    destinationCommitId: ObjectId,
    baseCommitId: ObjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse = {
    import GetMergeOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse
      .builder()
      .mergeOptionsWithStrings(mergeOptions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .sourceCommitId(ObjectId.unwrap(sourceCommitId): java.lang.String)
      .destinationCommitId(
        ObjectId.unwrap(destinationCommitId): java.lang.String
      )
      .baseCommitId(ObjectId.unwrap(baseCommitId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly =
    zio.aws.codecommit.model.GetMergeOptionsResponse.wrap(buildAwsValue())
}
object GetMergeOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetMergeOptionsResponse =
      zio.aws.codecommit.model.GetMergeOptionsResponse(
        mergeOptions,
        sourceCommitId,
        destinationCommitId,
        baseCommitId
      )
    def mergeOptions: List[zio.aws.codecommit.model.MergeOptionTypeEnum]
    def sourceCommitId: ObjectId
    def destinationCommitId: ObjectId
    def baseCommitId: ObjectId
    def getMergeOptions: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.MergeOptionTypeEnum
    ]] = ZIO.succeed(mergeOptions)
    def getSourceCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(sourceCommitId)
    def getDestinationCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(destinationCommitId)
    def getBaseCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(baseCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse
  ) extends zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly {
    override val mergeOptions
        : List[zio.aws.codecommit.model.MergeOptionTypeEnum] = impl
      .mergeOptions()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.MergeOptionTypeEnum.wrap(item)
      }
      .toList
    override val sourceCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.sourceCommitId())
    override val destinationCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.destinationCommitId())
    override val baseCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.baseCommitId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse
  ): zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
