package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRepositoryTriggersRequest(repositoryName: RepositoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest = {
    import GetRepositoryTriggersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetRepositoryTriggersRequest.ReadOnly =
    zio.aws.codecommit.model.GetRepositoryTriggersRequest.wrap(buildAwsValue())
}
object GetRepositoryTriggersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetRepositoryTriggersRequest =
      zio.aws.codecommit.model.GetRepositoryTriggersRequest(repositoryName)
    def repositoryName: RepositoryName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest
  ) extends zio.aws.codecommit.model.GetRepositoryTriggersRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest
  ): zio.aws.codecommit.model.GetRepositoryTriggersRequest.ReadOnly =
    new Wrapper(impl)
}
