package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, CommitName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFolderRequest(
    repositoryName: RepositoryName,
    commitSpecifier: Optional[CommitName] = Optional.Absent,
    folderPath: Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetFolderRequest = {
    import GetFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetFolderRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        commitSpecifier.map(value => CommitName.unwrap(value): java.lang.String)
      )(_.commitSpecifier)
      .folderPath(Path.unwrap(folderPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetFolderRequest.ReadOnly =
    zio.aws.codecommit.model.GetFolderRequest.wrap(buildAwsValue())
}
object GetFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetFolderRequest =
      zio.aws.codecommit.model.GetFolderRequest(
        repositoryName,
        commitSpecifier.map(value => value),
        folderPath
      )
    def repositoryName: RepositoryName
    def commitSpecifier: Optional[CommitName]
    def folderPath: Path
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getCommitSpecifier: ZIO[Any, AwsError, CommitName] =
      AwsError.unwrapOptionField("commitSpecifier", commitSpecifier)
    def getFolderPath: ZIO[Any, Nothing, Path] = ZIO.succeed(folderPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetFolderRequest
  ) extends zio.aws.codecommit.model.GetFolderRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val commitSpecifier: Optional[CommitName] = zio.aws.core.internal
      .optionalFromNullable(impl.commitSpecifier())
      .map(value => zio.aws.codecommit.model.primitives.CommitName(value))
    override val folderPath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.folderPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetFolderRequest
  ): zio.aws.codecommit.model.GetFolderRequest.ReadOnly = new Wrapper(impl)
}
