package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.PullRequestId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPullRequestRequest(pullRequestId: PullRequestId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest = {
    import GetPullRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetPullRequestRequest.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestRequest.wrap(buildAwsValue())
}
object GetPullRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetPullRequestRequest =
      zio.aws.codecommit.model.GetPullRequestRequest(pullRequestId)
    def pullRequestId: PullRequestId
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest
  ) extends zio.aws.codecommit.model.GetPullRequestRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest
  ): zio.aws.codecommit.model.GetPullRequestRequest.ReadOnly = new Wrapper(impl)
}
