package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryTriggerExecutionFailureMessage,
  RepositoryTriggerName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RepositoryTriggerExecutionFailure(
    trigger: Optional[RepositoryTriggerName] = Optional.Absent,
    failureMessage: Optional[RepositoryTriggerExecutionFailureMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure = {
    import RepositoryTriggerExecutionFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure
      .builder()
      .optionallyWith(
        trigger.map(value =>
          RepositoryTriggerName.unwrap(value): java.lang.String
        )
      )(_.trigger)
      .optionallyWith(
        failureMessage.map(value =>
          RepositoryTriggerExecutionFailureMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.failureMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly =
    zio.aws.codecommit.model.RepositoryTriggerExecutionFailure
      .wrap(buildAwsValue())
}
object RepositoryTriggerExecutionFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryTriggerExecutionFailure =
      zio.aws.codecommit.model.RepositoryTriggerExecutionFailure(
        trigger.map(value => value),
        failureMessage.map(value => value)
      )
    def trigger: Optional[RepositoryTriggerName]
    def failureMessage: Optional[RepositoryTriggerExecutionFailureMessage]
    def getTrigger: ZIO[Any, AwsError, RepositoryTriggerName] =
      AwsError.unwrapOptionField("trigger", trigger)
    def getFailureMessage
        : ZIO[Any, AwsError, RepositoryTriggerExecutionFailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure
  ) extends zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly {
    override val trigger: Optional[RepositoryTriggerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trigger())
        .map(value =>
          zio.aws.codecommit.model.primitives.RepositoryTriggerName(value)
        )
    override val failureMessage
        : Optional[RepositoryTriggerExecutionFailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value =>
          zio.aws.codecommit.model.primitives
            .RepositoryTriggerExecutionFailureMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure
  ): zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly =
    new Wrapper(impl)
}
