package zio.aws.codecommit.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecommit.model.primitives.{Arn, EventDate, PullRequestId}
import scala.jdk.CollectionConverters._
final case class PullRequestEvent(
    pullRequestId: Optional[PullRequestId] = Optional.Absent,
    eventDate: Optional[EventDate] = Optional.Absent,
    pullRequestEventType: Optional[
      zio.aws.codecommit.model.PullRequestEventType
    ] = Optional.Absent,
    actorArn: Optional[Arn] = Optional.Absent,
    pullRequestCreatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata
    ] = Optional.Absent,
    pullRequestStatusChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata
    ] = Optional.Absent,
    pullRequestSourceReferenceUpdatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
    ] = Optional.Absent,
    pullRequestMergedStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata
    ] = Optional.Absent,
    approvalRuleEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalRuleEventMetadata
    ] = Optional.Absent,
    approvalStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata
    ] = Optional.Absent,
    approvalRuleOverriddenEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestEvent = {
    import PullRequestEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestEvent
      .builder()
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(eventDate.map(value => EventDate.unwrap(value): Instant))(
        _.eventDate
      )
      .optionallyWith(pullRequestEventType.map(value => value.unwrap))(
        _.pullRequestEventType
      )
      .optionallyWith(
        actorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.actorArn)
      .optionallyWith(
        pullRequestCreatedEventMetadata.map(value => value.buildAwsValue())
      )(_.pullRequestCreatedEventMetadata)
      .optionallyWith(
        pullRequestStatusChangedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestStatusChangedEventMetadata)
      .optionallyWith(
        pullRequestSourceReferenceUpdatedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestSourceReferenceUpdatedEventMetadata)
      .optionallyWith(
        pullRequestMergedStateChangedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestMergedStateChangedEventMetadata)
      .optionallyWith(
        approvalRuleEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalRuleEventMetadata)
      .optionallyWith(
        approvalStateChangedEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalStateChangedEventMetadata)
      .optionallyWith(
        approvalRuleOverriddenEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalRuleOverriddenEventMetadata)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequestEvent.ReadOnly =
    zio.aws.codecommit.model.PullRequestEvent.wrap(buildAwsValue())
}
object PullRequestEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequestEvent =
      zio.aws.codecommit.model.PullRequestEvent(
        pullRequestId.map(value => value),
        eventDate.map(value => value),
        pullRequestEventType.map(value => value),
        actorArn.map(value => value),
        pullRequestCreatedEventMetadata.map(value => value.asEditable),
        pullRequestStatusChangedEventMetadata.map(value => value.asEditable),
        pullRequestSourceReferenceUpdatedEventMetadata.map(value =>
          value.asEditable
        ),
        pullRequestMergedStateChangedEventMetadata.map(value =>
          value.asEditable
        ),
        approvalRuleEventMetadata.map(value => value.asEditable),
        approvalStateChangedEventMetadata.map(value => value.asEditable),
        approvalRuleOverriddenEventMetadata.map(value => value.asEditable)
      )
    def pullRequestId: Optional[PullRequestId]
    def eventDate: Optional[EventDate]
    def pullRequestEventType
        : Optional[zio.aws.codecommit.model.PullRequestEventType]
    def actorArn: Optional[Arn]
    def pullRequestCreatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ]
    def pullRequestStatusChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ]
    def pullRequestSourceReferenceUpdatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ]
    def pullRequestMergedStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ]
    def approvalRuleEventMetadata
        : Optional[zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly]
    def approvalStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ]
    def approvalRuleOverriddenEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ]
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getEventDate: ZIO[Any, AwsError, EventDate] =
      AwsError.unwrapOptionField("eventDate", eventDate)
    def getPullRequestEventType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestEventType] =
      AwsError.unwrapOptionField("pullRequestEventType", pullRequestEventType)
    def getActorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("actorArn", actorArn)
    def getPullRequestCreatedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestCreatedEventMetadata",
      pullRequestCreatedEventMetadata
    )
    def getPullRequestStatusChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestStatusChangedEventMetadata",
      pullRequestStatusChangedEventMetadata
    )
    def getPullRequestSourceReferenceUpdatedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestSourceReferenceUpdatedEventMetadata",
      pullRequestSourceReferenceUpdatedEventMetadata
    )
    def getPullRequestMergedStateChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestMergedStateChangedEventMetadata",
      pullRequestMergedStateChangedEventMetadata
    )
    def getApprovalRuleEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalRuleEventMetadata",
      approvalRuleEventMetadata
    )
    def getApprovalStateChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalStateChangedEventMetadata",
      approvalStateChangedEventMetadata
    )
    def getApprovalRuleOverriddenEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalRuleOverriddenEventMetadata",
      approvalRuleOverriddenEventMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ) extends zio.aws.codecommit.model.PullRequestEvent.ReadOnly {
    override val pullRequestId: Optional[PullRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val eventDate: Optional[EventDate] = zio.aws.core.internal
      .optionalFromNullable(impl.eventDate())
      .map(value => zio.aws.codecommit.model.primitives.EventDate(value))
    override val pullRequestEventType
        : Optional[zio.aws.codecommit.model.PullRequestEventType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullRequestEventType())
        .map(value => zio.aws.codecommit.model.PullRequestEventType.wrap(value))
    override val actorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.actorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val pullRequestCreatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestCreatedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestCreatedEventMetadata.wrap(value)
      )
    override val pullRequestStatusChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestStatusChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata
          .wrap(value)
      )
    override val pullRequestSourceReferenceUpdatedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.pullRequestSourceReferenceUpdatedEventMetadata()
      )
      .map(value =>
        zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
          .wrap(value)
      )
    override val pullRequestMergedStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestMergedStateChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata
          .wrap(value)
      )
    override val approvalRuleEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalRuleEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.ApprovalRuleEventMetadata.wrap(value)
      )
    override val approvalStateChangedEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalStateChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.wrap(value)
      )
    override val approvalRuleOverriddenEventMetadata: Optional[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalRuleOverriddenEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ): zio.aws.codecommit.model.PullRequestEvent.ReadOnly = new Wrapper(impl)
}
