package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{BranchName, RepositoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBranchRequest(
    repositoryName: RepositoryName,
    branchName: BranchName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest = {
    import DeleteBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteBranchRequest.ReadOnly =
    zio.aws.codecommit.model.DeleteBranchRequest.wrap(buildAwsValue())
}
object DeleteBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteBranchRequest =
      zio.aws.codecommit.model.DeleteBranchRequest(repositoryName, branchName)
    def repositoryName: RepositoryName
    def branchName: BranchName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest
  ) extends zio.aws.codecommit.model.DeleteBranchRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest
  ): zio.aws.codecommit.model.DeleteBranchRequest.ReadOnly = new Wrapper(impl)
}
