package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRepositoriesForApprovalRuleTemplateResponse(
    repositoryNames: Optional[Iterable[RepositoryName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse = {
    import ListRepositoriesForApprovalRuleTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
      .builder()
      .optionallyWith(
        repositoryNames.map(value =>
          value.map { item =>
            RepositoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.repositoryNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly =
    zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
      .wrap(buildAwsValue())
}
object ListRepositoriesForApprovalRuleTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse =
      zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse(
        repositoryNames.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryNames: Optional[List[RepositoryName]]
    def nextToken: Optional[NextToken]
    def getRepositoryNames: ZIO[Any, AwsError, List[RepositoryName]] =
      AwsError.unwrapOptionField("repositoryNames", repositoryNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
  ) extends zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly {
    override val repositoryNames: Optional[List[RepositoryName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.RepositoryName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
  ): zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
