package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryDescription,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRepositoryDescriptionRequest(
    repositoryName: RepositoryName,
    repositoryDescription: Optional[RepositoryDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest = {
    import UpdateRepositoryDescriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        repositoryDescription.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.repositoryDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest
      .wrap(buildAwsValue())
}
object UpdateRepositoryDescriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest =
      zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest(
        repositoryName,
        repositoryDescription.map(value => value)
      )
    def repositoryName: RepositoryName
    def repositoryDescription: Optional[RepositoryDescription]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("repositoryDescription", repositoryDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest
  ) extends zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryDescription: Optional[RepositoryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryDescription())
        .map(value =>
          zio.aws.codecommit.model.primitives.RepositoryDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest
  ): zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest.ReadOnly =
    new Wrapper(impl)
}
