package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EvaluatePullRequestApprovalRulesResponse(
    evaluation: zio.aws.codecommit.model.Evaluation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse = {
    import EvaluatePullRequestApprovalRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
      .builder()
      .evaluation(evaluation.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly =
    zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse
      .wrap(buildAwsValue())
}
object EvaluatePullRequestApprovalRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse =
      zio.aws.codecommit.model
        .EvaluatePullRequestApprovalRulesResponse(evaluation.asEditable)
    def evaluation: zio.aws.codecommit.model.Evaluation.ReadOnly
    def getEvaluation
        : ZIO[Any, Nothing, zio.aws.codecommit.model.Evaluation.ReadOnly] =
      ZIO.succeed(evaluation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
  ) extends zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly {
    override val evaluation: zio.aws.codecommit.model.Evaluation.ReadOnly =
      zio.aws.codecommit.model.Evaluation.wrap(impl.evaluation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
  ): zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly =
    new Wrapper(impl)
}
