package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCommentReactionsResponse(
    reactionsForComment: Iterable[zio.aws.codecommit.model.ReactionForComment],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse = {
    import GetCommentReactionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse
      .builder()
      .reactionsForComment(reactionsForComment.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly =
    zio.aws.codecommit.model.GetCommentReactionsResponse.wrap(buildAwsValue())
}
object GetCommentReactionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentReactionsResponse =
      zio.aws.codecommit.model.GetCommentReactionsResponse(
        reactionsForComment.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def reactionsForComment
        : List[zio.aws.codecommit.model.ReactionForComment.ReadOnly]
    def nextToken: Optional[NextToken]
    def getReactionsForComment: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.ReactionForComment.ReadOnly
    ]] = ZIO.succeed(reactionsForComment)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse
  ) extends zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly {
    override val reactionsForComment
        : List[zio.aws.codecommit.model.ReactionForComment.ReadOnly] = impl
      .reactionsForComment()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.ReactionForComment.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse
  ): zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly =
    new Wrapper(impl)
}
