package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCommitResponse(commit: zio.aws.codecommit.model.Commit) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommitResponse = {
    import GetCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommitResponse
      .builder()
      .commit(commit.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetCommitResponse.ReadOnly =
    zio.aws.codecommit.model.GetCommitResponse.wrap(buildAwsValue())
}
object GetCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommitResponse =
      zio.aws.codecommit.model.GetCommitResponse(commit.asEditable)
    def commit: zio.aws.codecommit.model.Commit.ReadOnly
    def getCommit: ZIO[Any, Nothing, zio.aws.codecommit.model.Commit.ReadOnly] =
      ZIO.succeed(commit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommitResponse
  ) extends zio.aws.codecommit.model.GetCommitResponse.ReadOnly {
    override val commit: zio.aws.codecommit.model.Commit.ReadOnly =
      zio.aws.codecommit.model.Commit.wrap(impl.commit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommitResponse
  ): zio.aws.codecommit.model.GetCommitResponse.ReadOnly = new Wrapper(impl)
}
