package zio.aws.codecommit
import zio.aws.codecommit.model.GetFileResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.codecommit.model.{
  BatchAssociateApprovalRuleTemplateWithRepositoriesRequest,
  DeleteFileRequest,
  GetBlobRequest,
  MergeBranchesBySquashRequest,
  ListApprovalRuleTemplatesRequest,
  ListPullRequestsRequest,
  GetPullRequestApprovalStatesRequest,
  UpdatePullRequestApprovalStateRequest,
  PutRepositoryTriggersRequest,
  CreateApprovalRuleTemplateRequest,
  GetCommentsForPullRequestRequest,
  OverridePullRequestApprovalRulesRequest,
  GetCommentReactionsRequest,
  GetCommitRequest,
  DescribeMergeConflictsRequest,
  UpdateDefaultBranchRequest,
  DeleteCommentContentRequest,
  GetRepositoryTriggersRequest,
  UpdateApprovalRuleTemplateDescriptionRequest,
  GetBranchRequest,
  PostCommentForPullRequestRequest,
  ListTagsForResourceRequest,
  UpdatePullRequestStatusRequest,
  UpdateApprovalRuleTemplateContentRequest,
  TestRepositoryTriggersRequest,
  MergePullRequestBySquashRequest,
  GetMergeConflictsRequest,
  GetPullRequestOverrideStateRequest,
  ListRepositoriesForApprovalRuleTemplateRequest,
  GetDifferencesRequest,
  DeletePullRequestApprovalRuleRequest,
  CreatePullRequestApprovalRuleRequest,
  DisassociateApprovalRuleTemplateFromRepositoryRequest,
  CreateRepositoryRequest,
  CreateBranchRequest,
  BatchGetRepositoriesRequest,
  PostCommentReplyRequest,
  CreateUnreferencedMergeCommitRequest,
  AssociateApprovalRuleTemplateWithRepositoryRequest,
  GetFolderRequest,
  MergeBranchesByThreeWayRequest,
  MergePullRequestByThreeWayRequest,
  UpdateRepositoryNameRequest,
  UpdateRepositoryDescriptionRequest,
  GetCommentRequest,
  BatchDescribeMergeConflictsRequest,
  GetFileRequest,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListBranchesRequest,
  EvaluatePullRequestApprovalRulesRequest,
  CreateCommitRequest,
  DescribePullRequestEventsRequest,
  UpdateCommentRequest,
  UpdatePullRequestDescriptionRequest,
  PostCommentForComparedCommitRequest,
  BatchGetCommitsRequest,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest,
  GetPullRequestRequest,
  PutCommentReactionRequest,
  UpdatePullRequestApprovalRuleContentRequest,
  DeleteApprovalRuleTemplateRequest,
  DeleteRepositoryRequest,
  GetMergeCommitRequest,
  MergePullRequestByFastForwardRequest,
  GetApprovalRuleTemplateRequest,
  GetCommentsForComparedCommitRequest,
  GetMergeOptionsRequest,
  UpdatePullRequestTitleRequest,
  UpdateApprovalRuleTemplateNameRequest,
  DeleteBranchRequest,
  TagResourceRequest,
  PutFileRequest,
  MergeBranchesByFastForwardRequest,
  ListAssociatedApprovalRuleTemplatesForRepositoryRequest,
  GetRepositoryRequest,
  CreatePullRequestRequest
}
import zio.aws.codecommit.model.primitives.BranchName
object CodeCommitMock extends Mock[CodeCommit] {
  object GetCommentReactions
      extends Effect[
        GetCommentReactionsRequest,
        AwsError,
        zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly
      ]
  object UpdatePullRequestApprovalRuleContent
      extends Effect[
        UpdatePullRequestApprovalRuleContentRequest,
        AwsError,
        zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.ReadOnly
      ]
  object DescribeMergeConflicts
      extends Effect[
        DescribeMergeConflictsRequest,
        AwsError,
        zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly
      ]
  object UpdateApprovalRuleTemplateContent
      extends Effect[
        UpdateApprovalRuleTemplateContentRequest,
        AwsError,
        zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.ReadOnly
      ]
  object UpdateRepositoryName
      extends Effect[UpdateRepositoryNameRequest, AwsError, Unit]
  object GetRepositoryTriggers
      extends Effect[
        GetRepositoryTriggersRequest,
        AwsError,
        zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly
      ]
  object UpdatePullRequestTitle
      extends Effect[
        UpdatePullRequestTitleRequest,
        AwsError,
        zio.aws.codecommit.model.UpdatePullRequestTitleResponse.ReadOnly
      ]
  object PostCommentReply
      extends Effect[
        PostCommentReplyRequest,
        AwsError,
        zio.aws.codecommit.model.PostCommentReplyResponse.ReadOnly
      ]
  object DeleteCommentContent
      extends Effect[
        DeleteCommentContentRequest,
        AwsError,
        zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly
      ]
  object EvaluatePullRequestApprovalRules
      extends Effect[
        EvaluatePullRequestApprovalRulesRequest,
        AwsError,
        zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly
      ]
  object OverridePullRequestApprovalRules
      extends Effect[OverridePullRequestApprovalRulesRequest, AwsError, Unit]
  object GetDifferences
      extends Stream[
        GetDifferencesRequest,
        AwsError,
        zio.aws.codecommit.model.Difference.ReadOnly
      ]
  object GetDifferencesPaginated
      extends Effect[
        GetDifferencesRequest,
        AwsError,
        zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly
      ]
  object UpdatePullRequestApprovalState
      extends Effect[UpdatePullRequestApprovalStateRequest, AwsError, Unit]
  object PostCommentForPullRequest
      extends Effect[
        PostCommentForPullRequestRequest,
        AwsError,
        zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly
      ]
  object GetFile extends Effect[GetFileRequest, AwsError, ReadOnly]
  object GetPullRequestApprovalStates
      extends Effect[
        GetPullRequestApprovalStatesRequest,
        AwsError,
        zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly
      ]
  object GetRepository
      extends Effect[
        GetRepositoryRequest,
        AwsError,
        zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly
      ]
  object DeleteBranch
      extends Effect[
        DeleteBranchRequest,
        AwsError,
        zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly
      ]
  object DeleteRepository
      extends Effect[
        DeleteRepositoryRequest,
        AwsError,
        zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly
      ]
  object GetCommit
      extends Effect[
        GetCommitRequest,
        AwsError,
        zio.aws.codecommit.model.GetCommitResponse.ReadOnly
      ]
  object DeleteApprovalRuleTemplate
      extends Effect[
        DeleteApprovalRuleTemplateRequest,
        AwsError,
        zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly
      ]
  object UpdateApprovalRuleTemplateDescription
      extends Effect[
        UpdateApprovalRuleTemplateDescriptionRequest,
        AwsError,
        zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.ReadOnly
      ]
  object GetMergeConflicts
      extends Effect[
        GetMergeConflictsRequest,
        AwsError,
        zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly
      ]
  object UpdatePullRequestDescription
      extends Effect[
        UpdatePullRequestDescriptionRequest,
        AwsError,
        zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.ReadOnly
      ]
  object TestRepositoryTriggers
      extends Effect[
        TestRepositoryTriggersRequest,
        AwsError,
        zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly
      ]
  object GetMergeOptions
      extends Effect[
        GetMergeOptionsRequest,
        AwsError,
        zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly
      ]
  object BatchGetRepositories
      extends Effect[
        BatchGetRepositoriesRequest,
        AwsError,
        zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly
      ]
  object GetApprovalRuleTemplate
      extends Effect[
        GetApprovalRuleTemplateRequest,
        AwsError,
        zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.ReadOnly
      ]
  object CreatePullRequestApprovalRule
      extends Effect[
        CreatePullRequestApprovalRuleRequest,
        AwsError,
        zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.ReadOnly
      ]
  object BatchDisassociateApprovalRuleTemplateFromRepositories
      extends Effect[
        BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest,
        AwsError,
        zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly
      ]
  object CreateBranch extends Effect[CreateBranchRequest, AwsError, Unit]
  object GetFolder
      extends Effect[
        GetFolderRequest,
        AwsError,
        zio.aws.codecommit.model.GetFolderResponse.ReadOnly
      ]
  object CreateApprovalRuleTemplate
      extends Effect[
        CreateApprovalRuleTemplateRequest,
        AwsError,
        zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.ReadOnly
      ]
  object CreateRepository
      extends Effect[
        CreateRepositoryRequest,
        AwsError,
        zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly
      ]
  object UpdateComment
      extends Effect[
        UpdateCommentRequest,
        AwsError,
        zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly
      ]
  object PostCommentForComparedCommit
      extends Effect[
        PostCommentForComparedCommitRequest,
        AwsError,
        zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly
      ]
  object CreateUnreferencedMergeCommit
      extends Effect[
        CreateUnreferencedMergeCommitRequest,
        AwsError,
        zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.ReadOnly
      ]
  object MergeBranchesByThreeWay
      extends Effect[
        MergeBranchesByThreeWayRequest,
        AwsError,
        zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly
      ]
  object ListApprovalRuleTemplates
      extends Effect[
        ListApprovalRuleTemplatesRequest,
        AwsError,
        zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.ReadOnly
      ]
  object PutRepositoryTriggers
      extends Effect[
        PutRepositoryTriggersRequest,
        AwsError,
        zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly
      ]
  object PutFile
      extends Effect[
        PutFileRequest,
        AwsError,
        zio.aws.codecommit.model.PutFileResponse.ReadOnly
      ]
  object DescribePullRequestEvents
      extends Effect[
        DescribePullRequestEventsRequest,
        AwsError,
        zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly
      ]
  object DisassociateApprovalRuleTemplateFromRepository
      extends Effect[
        DisassociateApprovalRuleTemplateFromRepositoryRequest,
        AwsError,
        Unit
      ]
  object PutCommentReaction
      extends Effect[PutCommentReactionRequest, AwsError, Unit]
  object ListRepositoriesForApprovalRuleTemplate
      extends Effect[
        ListRepositoriesForApprovalRuleTemplateRequest,
        AwsError,
        zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly
      ]
  object GetCommentsForComparedCommit
      extends Effect[
        GetCommentsForComparedCommitRequest,
        AwsError,
        zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly
      ]
  object MergePullRequestByFastForward
      extends Effect[
        MergePullRequestByFastForwardRequest,
        AwsError,
        zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly
      ]
  object ListAssociatedApprovalRuleTemplatesForRepository
      extends Effect[
        ListAssociatedApprovalRuleTemplatesForRepositoryRequest,
        AwsError,
        zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly
      ]
  object UpdateApprovalRuleTemplateName
      extends Effect[
        UpdateApprovalRuleTemplateNameRequest,
        AwsError,
        zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.ReadOnly
      ]
  object ListBranches extends Stream[ListBranchesRequest, AwsError, BranchName]
  object ListBranchesPaginated
      extends Effect[
        ListBranchesRequest,
        AwsError,
        zio.aws.codecommit.model.ListBranchesResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetPullRequestOverrideState
      extends Effect[
        GetPullRequestOverrideStateRequest,
        AwsError,
        zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly
      ]
  object MergeBranchesBySquash
      extends Effect[
        MergeBranchesBySquashRequest,
        AwsError,
        zio.aws.codecommit.model.MergeBranchesBySquashResponse.ReadOnly
      ]
  object MergePullRequestByThreeWay
      extends Effect[
        MergePullRequestByThreeWayRequest,
        AwsError,
        zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly
      ]
  object BatchAssociateApprovalRuleTemplateWithRepositories
      extends Effect[
        BatchAssociateApprovalRuleTemplateWithRepositoriesRequest,
        AwsError,
        zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly
      ]
  object DeleteFile
      extends Effect[
        DeleteFileRequest,
        AwsError,
        zio.aws.codecommit.model.DeleteFileResponse.ReadOnly
      ]
  object UpdatePullRequestStatus
      extends Effect[
        UpdatePullRequestStatusRequest,
        AwsError,
        zio.aws.codecommit.model.UpdatePullRequestStatusResponse.ReadOnly
      ]
  object DeletePullRequestApprovalRule
      extends Effect[
        DeletePullRequestApprovalRuleRequest,
        AwsError,
        zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly
      ]
  object ListRepositories
      extends Stream[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
      ]
  object ListRepositoriesPaginated
      extends Effect[
        ListRepositoriesRequest,
        AwsError,
        zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly
      ]
  object GetBranch
      extends Effect[
        GetBranchRequest,
        AwsError,
        zio.aws.codecommit.model.GetBranchResponse.ReadOnly
      ]
  object GetCommentsForPullRequest
      extends Effect[
        GetCommentsForPullRequestRequest,
        AwsError,
        zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly
      ]
  object BatchGetCommits
      extends Effect[
        BatchGetCommitsRequest,
        AwsError,
        zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly
      ]
  object MergeBranchesByFastForward
      extends Effect[
        MergeBranchesByFastForwardRequest,
        AwsError,
        zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codecommit.model.ListTagsForResourceResponse.ReadOnly
      ]
  object AssociateApprovalRuleTemplateWithRepository
      extends Effect[
        AssociateApprovalRuleTemplateWithRepositoryRequest,
        AwsError,
        Unit
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object CreateCommit
      extends Effect[
        CreateCommitRequest,
        AwsError,
        zio.aws.codecommit.model.CreateCommitResponse.ReadOnly
      ]
  object UpdateDefaultBranch
      extends Effect[UpdateDefaultBranchRequest, AwsError, Unit]
  object GetBlob
      extends Effect[
        GetBlobRequest,
        AwsError,
        zio.aws.codecommit.model.GetBlobResponse.ReadOnly
      ]
  object GetPullRequest
      extends Effect[
        GetPullRequestRequest,
        AwsError,
        zio.aws.codecommit.model.GetPullRequestResponse.ReadOnly
      ]
  object GetComment
      extends Effect[
        GetCommentRequest,
        AwsError,
        zio.aws.codecommit.model.GetCommentResponse.ReadOnly
      ]
  object ListPullRequests
      extends Effect[
        ListPullRequestsRequest,
        AwsError,
        zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly
      ]
  object BatchDescribeMergeConflicts
      extends Effect[
        BatchDescribeMergeConflictsRequest,
        AwsError,
        zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly
      ]
  object CreatePullRequest
      extends Effect[
        CreatePullRequestRequest,
        AwsError,
        zio.aws.codecommit.model.CreatePullRequestResponse.ReadOnly
      ]
  object MergePullRequestBySquash
      extends Effect[
        MergePullRequestBySquashRequest,
        AwsError,
        zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly
      ]
  object GetMergeCommit
      extends Effect[
        GetMergeCommitRequest,
        AwsError,
        zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly
      ]
  object UpdateRepositoryDescription
      extends Effect[UpdateRepositoryDescriptionRequest, AwsError, Unit]
  val compose: URLayer[Proxy, CodeCommit] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeCommit] { rts =>
        zio.ZIO.succeed {
          new CodeCommit {
            val api: CodeCommitAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeCommit = this
            def getCommentReactions(request: GetCommentReactionsRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly
            ] = proxy(GetCommentReactions, request)
            def updatePullRequestApprovalRuleContent(
                request: UpdatePullRequestApprovalRuleContentRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.ReadOnly
            ] = proxy(UpdatePullRequestApprovalRuleContent, request)
            def describeMergeConflicts(
                request: DescribeMergeConflictsRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly
            ] = proxy(DescribeMergeConflicts, request)
            def updateApprovalRuleTemplateContent(
                request: UpdateApprovalRuleTemplateContentRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.ReadOnly
            ] = proxy(UpdateApprovalRuleTemplateContent, request)
            def updateRepositoryName(
                request: UpdateRepositoryNameRequest
            ): IO[AwsError, Unit] = proxy(UpdateRepositoryName, request)
            def getRepositoryTriggers(
                request: GetRepositoryTriggersRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly
            ] = proxy(GetRepositoryTriggers, request)
            def updatePullRequestTitle(
                request: UpdatePullRequestTitleRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdatePullRequestTitleResponse.ReadOnly
            ] = proxy(UpdatePullRequestTitle, request)
            def postCommentReply(request: PostCommentReplyRequest): IO[
              AwsError,
              zio.aws.codecommit.model.PostCommentReplyResponse.ReadOnly
            ] = proxy(PostCommentReply, request)
            def deleteCommentContent(request: DeleteCommentContentRequest): IO[
              AwsError,
              zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly
            ] = proxy(DeleteCommentContent, request)
            def evaluatePullRequestApprovalRules(
                request: EvaluatePullRequestApprovalRulesRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly
            ] = proxy(EvaluatePullRequestApprovalRules, request)
            def overridePullRequestApprovalRules(
                request: OverridePullRequestApprovalRulesRequest
            ): IO[AwsError, Unit] =
              proxy(OverridePullRequestApprovalRules, request)
            def getDifferences(request: GetDifferencesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecommit.model.Difference.ReadOnly
            ] = rts.unsafeRun(proxy(GetDifferences, request))
            def getDifferencesPaginated(request: GetDifferencesRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly
            ] = proxy(GetDifferencesPaginated, request)
            def updatePullRequestApprovalState(
                request: UpdatePullRequestApprovalStateRequest
            ): IO[AwsError, Unit] =
              proxy(UpdatePullRequestApprovalState, request)
            def postCommentForPullRequest(
                request: PostCommentForPullRequestRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly
            ] = proxy(PostCommentForPullRequest, request)
            def getFile(request: GetFileRequest): IO[AwsError, ReadOnly] =
              proxy(GetFile, request)
            def getPullRequestApprovalStates(
                request: GetPullRequestApprovalStatesRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly
            ] = proxy(GetPullRequestApprovalStates, request)
            def getRepository(request: GetRepositoryRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly
            ] = proxy(GetRepository, request)
            def deleteBranch(request: DeleteBranchRequest): IO[
              AwsError,
              zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly
            ] = proxy(DeleteBranch, request)
            def deleteRepository(request: DeleteRepositoryRequest): IO[
              AwsError,
              zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly
            ] = proxy(DeleteRepository, request)
            def getCommit(request: GetCommitRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetCommitResponse.ReadOnly
            ] = proxy(GetCommit, request)
            def deleteApprovalRuleTemplate(
                request: DeleteApprovalRuleTemplateRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly
            ] = proxy(DeleteApprovalRuleTemplate, request)
            def updateApprovalRuleTemplateDescription(
                request: UpdateApprovalRuleTemplateDescriptionRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.ReadOnly
            ] = proxy(UpdateApprovalRuleTemplateDescription, request)
            def getMergeConflicts(request: GetMergeConflictsRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly
            ] = proxy(GetMergeConflicts, request)
            def updatePullRequestDescription(
                request: UpdatePullRequestDescriptionRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.ReadOnly
            ] = proxy(UpdatePullRequestDescription, request)
            def testRepositoryTriggers(
                request: TestRepositoryTriggersRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly
            ] = proxy(TestRepositoryTriggers, request)
            def getMergeOptions(request: GetMergeOptionsRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly
            ] = proxy(GetMergeOptions, request)
            def batchGetRepositories(request: BatchGetRepositoriesRequest): IO[
              AwsError,
              zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly
            ] = proxy(BatchGetRepositories, request)
            def getApprovalRuleTemplate(
                request: GetApprovalRuleTemplateRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.ReadOnly
            ] = proxy(GetApprovalRuleTemplate, request)
            def createPullRequestApprovalRule(
                request: CreatePullRequestApprovalRuleRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.ReadOnly
            ] = proxy(CreatePullRequestApprovalRule, request)
            def batchDisassociateApprovalRuleTemplateFromRepositories(
                request: BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly
            ] = proxy(
              BatchDisassociateApprovalRuleTemplateFromRepositories,
              request
            )
            def createBranch(request: CreateBranchRequest): IO[AwsError, Unit] =
              proxy(CreateBranch, request)
            def getFolder(request: GetFolderRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetFolderResponse.ReadOnly
            ] = proxy(GetFolder, request)
            def createApprovalRuleTemplate(
                request: CreateApprovalRuleTemplateRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.ReadOnly
            ] = proxy(CreateApprovalRuleTemplate, request)
            def createRepository(request: CreateRepositoryRequest): IO[
              AwsError,
              zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly
            ] = proxy(CreateRepository, request)
            def updateComment(request: UpdateCommentRequest): IO[
              AwsError,
              zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly
            ] = proxy(UpdateComment, request)
            def postCommentForComparedCommit(
                request: PostCommentForComparedCommitRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly
            ] = proxy(PostCommentForComparedCommit, request)
            def createUnreferencedMergeCommit(
                request: CreateUnreferencedMergeCommitRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.ReadOnly
            ] = proxy(CreateUnreferencedMergeCommit, request)
            def mergeBranchesByThreeWay(
                request: MergeBranchesByThreeWayRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly
            ] = proxy(MergeBranchesByThreeWay, request)
            def listApprovalRuleTemplates(
                request: ListApprovalRuleTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.ReadOnly
            ] = proxy(ListApprovalRuleTemplates, request)
            def putRepositoryTriggers(
                request: PutRepositoryTriggersRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly
            ] = proxy(PutRepositoryTriggers, request)
            def putFile(
                request: PutFileRequest
            ): IO[AwsError, zio.aws.codecommit.model.PutFileResponse.ReadOnly] =
              proxy(PutFile, request)
            def describePullRequestEvents(
                request: DescribePullRequestEventsRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly
            ] = proxy(DescribePullRequestEvents, request)
            def disassociateApprovalRuleTemplateFromRepository(
                request: DisassociateApprovalRuleTemplateFromRepositoryRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateApprovalRuleTemplateFromRepository, request)
            def putCommentReaction(
                request: PutCommentReactionRequest
            ): IO[AwsError, Unit] = proxy(PutCommentReaction, request)
            def listRepositoriesForApprovalRuleTemplate(
                request: ListRepositoriesForApprovalRuleTemplateRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly
            ] = proxy(ListRepositoriesForApprovalRuleTemplate, request)
            def getCommentsForComparedCommit(
                request: GetCommentsForComparedCommitRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly
            ] = proxy(GetCommentsForComparedCommit, request)
            def mergePullRequestByFastForward(
                request: MergePullRequestByFastForwardRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly
            ] = proxy(MergePullRequestByFastForward, request)
            def listAssociatedApprovalRuleTemplatesForRepository(
                request: ListAssociatedApprovalRuleTemplatesForRepositoryRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly
            ] = proxy(ListAssociatedApprovalRuleTemplatesForRepository, request)
            def updateApprovalRuleTemplateName(
                request: UpdateApprovalRuleTemplateNameRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.ReadOnly
            ] = proxy(UpdateApprovalRuleTemplateName, request)
            def listBranches(
                request: ListBranchesRequest
            ): ZStream[Any, AwsError, BranchName] =
              rts.unsafeRun(proxy(ListBranches, request))
            def listBranchesPaginated(request: ListBranchesRequest): IO[
              AwsError,
              zio.aws.codecommit.model.ListBranchesResponse.ReadOnly
            ] = proxy(ListBranchesPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def getPullRequestOverrideState(
                request: GetPullRequestOverrideStateRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly
            ] = proxy(GetPullRequestOverrideState, request)
            def mergeBranchesBySquash(
                request: MergeBranchesBySquashRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergeBranchesBySquashResponse.ReadOnly
            ] = proxy(MergeBranchesBySquash, request)
            def mergePullRequestByThreeWay(
                request: MergePullRequestByThreeWayRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly
            ] = proxy(MergePullRequestByThreeWay, request)
            def batchAssociateApprovalRuleTemplateWithRepositories(
                request: BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly
            ] =
              proxy(BatchAssociateApprovalRuleTemplateWithRepositories, request)
            def deleteFile(request: DeleteFileRequest): IO[
              AwsError,
              zio.aws.codecommit.model.DeleteFileResponse.ReadOnly
            ] = proxy(DeleteFile, request)
            def updatePullRequestStatus(
                request: UpdatePullRequestStatusRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.UpdatePullRequestStatusResponse.ReadOnly
            ] = proxy(UpdatePullRequestStatus, request)
            def deletePullRequestApprovalRule(
                request: DeletePullRequestApprovalRuleRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly
            ] = proxy(DeletePullRequestApprovalRule, request)
            def listRepositories(request: ListRepositoriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
            ] = rts.unsafeRun(proxy(ListRepositories, request))
            def listRepositoriesPaginated(request: ListRepositoriesRequest): IO[
              AwsError,
              zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly
            ] = proxy(ListRepositoriesPaginated, request)
            def getBranch(request: GetBranchRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetBranchResponse.ReadOnly
            ] = proxy(GetBranch, request)
            def getCommentsForPullRequest(
                request: GetCommentsForPullRequestRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly
            ] = proxy(GetCommentsForPullRequest, request)
            def batchGetCommits(request: BatchGetCommitsRequest): IO[
              AwsError,
              zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly
            ] = proxy(BatchGetCommits, request)
            def mergeBranchesByFastForward(
                request: MergeBranchesByFastForwardRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.ReadOnly
            ] = proxy(MergeBranchesByFastForward, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codecommit.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def associateApprovalRuleTemplateWithRepository(
                request: AssociateApprovalRuleTemplateWithRepositoryRequest
            ): IO[AwsError, Unit] =
              proxy(AssociateApprovalRuleTemplateWithRepository, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def createCommit(request: CreateCommitRequest): IO[
              AwsError,
              zio.aws.codecommit.model.CreateCommitResponse.ReadOnly
            ] = proxy(CreateCommit, request)
            def updateDefaultBranch(
                request: UpdateDefaultBranchRequest
            ): IO[AwsError, Unit] = proxy(UpdateDefaultBranch, request)
            def getBlob(
                request: GetBlobRequest
            ): IO[AwsError, zio.aws.codecommit.model.GetBlobResponse.ReadOnly] =
              proxy(GetBlob, request)
            def getPullRequest(request: GetPullRequestRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetPullRequestResponse.ReadOnly
            ] = proxy(GetPullRequest, request)
            def getComment(request: GetCommentRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetCommentResponse.ReadOnly
            ] = proxy(GetComment, request)
            def listPullRequests(request: ListPullRequestsRequest): IO[
              AwsError,
              zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly
            ] = proxy(ListPullRequests, request)
            def batchDescribeMergeConflicts(
                request: BatchDescribeMergeConflictsRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly
            ] = proxy(BatchDescribeMergeConflicts, request)
            def createPullRequest(request: CreatePullRequestRequest): IO[
              AwsError,
              zio.aws.codecommit.model.CreatePullRequestResponse.ReadOnly
            ] = proxy(CreatePullRequest, request)
            def mergePullRequestBySquash(
                request: MergePullRequestBySquashRequest
            ): IO[
              AwsError,
              zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly
            ] = proxy(MergePullRequestBySquash, request)
            def getMergeCommit(request: GetMergeCommitRequest): IO[
              AwsError,
              zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly
            ] = proxy(GetMergeCommit, request)
            def updateRepositoryDescription(
                request: UpdateRepositoryDescriptionRequest
            ): IO[AwsError, Unit] = proxy(UpdateRepositoryDescription, request)
          }
        }
      }
    }
  }
}
