package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MergeBranchesByThreeWayResponse(
    commitId: Optional[ObjectId] = Optional.Absent,
    treeId: Optional[ObjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse = {
    import MergeBranchesByThreeWayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly =
    zio.aws.codecommit.model.MergeBranchesByThreeWayResponse
      .wrap(buildAwsValue())
}
object MergeBranchesByThreeWayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeBranchesByThreeWayResponse =
      zio.aws.codecommit.model.MergeBranchesByThreeWayResponse(
        commitId.map(value => value),
        treeId.map(value => value)
      )
    def commitId: Optional[ObjectId]
    def treeId: Optional[ObjectId]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ) extends zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly {
    override val commitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ): zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly =
    new Wrapper(impl)
}
