package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMergeConflictsResponse(
    conflictMetadata: zio.aws.codecommit.model.ConflictMetadata,
    mergeHunks: Iterable[zio.aws.codecommit.model.MergeHunk],
    nextToken: Optional[NextToken] = Optional.Absent,
    destinationCommitId: ObjectId,
    sourceCommitId: ObjectId,
    baseCommitId: Optional[ObjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse = {
    import DescribeMergeConflictsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse
      .builder()
      .conflictMetadata(conflictMetadata.buildAwsValue())
      .mergeHunks(mergeHunks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .destinationCommitId(
        ObjectId.unwrap(destinationCommitId): java.lang.String
      )
      .sourceCommitId(ObjectId.unwrap(sourceCommitId): java.lang.String)
      .optionallyWith(
        baseCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.baseCommitId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly =
    zio.aws.codecommit.model.DescribeMergeConflictsResponse
      .wrap(buildAwsValue())
}
object DescribeMergeConflictsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DescribeMergeConflictsResponse =
      zio.aws.codecommit.model.DescribeMergeConflictsResponse(
        conflictMetadata.asEditable,
        mergeHunks.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        destinationCommitId,
        sourceCommitId,
        baseCommitId.map(value => value)
      )
    def conflictMetadata: zio.aws.codecommit.model.ConflictMetadata.ReadOnly
    def mergeHunks: List[zio.aws.codecommit.model.MergeHunk.ReadOnly]
    def nextToken: Optional[NextToken]
    def destinationCommitId: ObjectId
    def sourceCommitId: ObjectId
    def baseCommitId: Optional[ObjectId]
    def getConflictMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.codecommit.model.ConflictMetadata.ReadOnly
    ] = ZIO.succeed(conflictMetadata)
    def getMergeHunks
        : ZIO[Any, Nothing, List[zio.aws.codecommit.model.MergeHunk.ReadOnly]] =
      ZIO.succeed(mergeHunks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinationCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(destinationCommitId)
    def getSourceCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(sourceCommitId)
    def getBaseCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("baseCommitId", baseCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse
  ) extends zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly {
    override val conflictMetadata
        : zio.aws.codecommit.model.ConflictMetadata.ReadOnly =
      zio.aws.codecommit.model.ConflictMetadata.wrap(impl.conflictMetadata())
    override val mergeHunks: List[zio.aws.codecommit.model.MergeHunk.ReadOnly] =
      impl
        .mergeHunks()
        .asScala
        .map { item =>
          zio.aws.codecommit.model.MergeHunk.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val destinationCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.destinationCommitId())
    override val sourceCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.sourceCommitId())
    override val baseCommitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.baseCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse
  ): zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly =
    new Wrapper(impl)
}
