package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  RepositoryName
}
import scala.jdk.CollectionConverters._
final case class ListAssociatedApprovalRuleTemplatesForRepositoryRequest(
    repositoryName: RepositoryName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest = {
    import ListAssociatedApprovalRuleTemplatesForRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
      .wrap(buildAwsValue())
}
object ListAssociatedApprovalRuleTemplatesForRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest =
      zio.aws.codecommit.model
        .ListAssociatedApprovalRuleTemplatesForRepositoryRequest(
          repositoryName,
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def repositoryName: RepositoryName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
  ) extends zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
  ): zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
