package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Difference(
    beforeBlob: Optional[zio.aws.codecommit.model.BlobMetadata] =
      Optional.Absent,
    afterBlob: Optional[zio.aws.codecommit.model.BlobMetadata] =
      Optional.Absent,
    changeType: Optional[zio.aws.codecommit.model.ChangeTypeEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Difference = {
    import Difference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Difference
      .builder()
      .optionallyWith(beforeBlob.map(value => value.buildAwsValue()))(
        _.beforeBlob
      )
      .optionallyWith(afterBlob.map(value => value.buildAwsValue()))(
        _.afterBlob
      )
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Difference.ReadOnly =
    zio.aws.codecommit.model.Difference.wrap(buildAwsValue())
}
object Difference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Difference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Difference =
      zio.aws.codecommit.model.Difference(
        beforeBlob.map(value => value.asEditable),
        afterBlob.map(value => value.asEditable),
        changeType.map(value => value)
      )
    def beforeBlob: Optional[zio.aws.codecommit.model.BlobMetadata.ReadOnly]
    def afterBlob: Optional[zio.aws.codecommit.model.BlobMetadata.ReadOnly]
    def changeType: Optional[zio.aws.codecommit.model.ChangeTypeEnum]
    def getBeforeBlob
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      AwsError.unwrapOptionField("beforeBlob", beforeBlob)
    def getAfterBlob
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      AwsError.unwrapOptionField("afterBlob", afterBlob)
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ChangeTypeEnum] =
      AwsError.unwrapOptionField("changeType", changeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Difference
  ) extends zio.aws.codecommit.model.Difference.ReadOnly {
    override val beforeBlob
        : Optional[zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.beforeBlob())
        .map(value => zio.aws.codecommit.model.BlobMetadata.wrap(value))
    override val afterBlob
        : Optional[zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.afterBlob())
        .map(value => zio.aws.codecommit.model.BlobMetadata.wrap(value))
    override val changeType: Optional[zio.aws.codecommit.model.ChangeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeType())
        .map(value => zio.aws.codecommit.model.ChangeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Difference
  ): zio.aws.codecommit.model.Difference.ReadOnly = new Wrapper(impl)
}
