package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleContent,
  ApprovalRuleName,
  PullRequestId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreatePullRequestApprovalRuleRequest(
    pullRequestId: PullRequestId,
    approvalRuleName: ApprovalRuleName,
    approvalRuleContent: ApprovalRuleContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest = {
    import CreatePullRequestApprovalRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .approvalRuleName(
        ApprovalRuleName.unwrap(approvalRuleName): java.lang.String
      )
      .approvalRuleContent(
        ApprovalRuleContent.unwrap(approvalRuleContent): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest.ReadOnly =
    zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest
      .wrap(buildAwsValue())
}
object CreatePullRequestApprovalRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest =
      zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest(
        pullRequestId,
        approvalRuleName,
        approvalRuleContent
      )
    def pullRequestId: PullRequestId
    def approvalRuleName: ApprovalRuleName
    def approvalRuleContent: ApprovalRuleContent
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getApprovalRuleName: ZIO[Any, Nothing, ApprovalRuleName] =
      ZIO.succeed(approvalRuleName)
    def getApprovalRuleContent: ZIO[Any, Nothing, ApprovalRuleContent] =
      ZIO.succeed(approvalRuleContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest
  ) extends zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val approvalRuleName: ApprovalRuleName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleName(impl.approvalRuleName())
    override val approvalRuleContent: ApprovalRuleContent =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleContent(impl.approvalRuleContent())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest
  ): zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest.ReadOnly =
    new Wrapper(impl)
}
