package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  NextToken,
  MaxResults,
  CommitName,
  RepositoryName
}
import scala.jdk.CollectionConverters._
final case class GetMergeConflictsRequest(
    repositoryName: RepositoryName,
    destinationCommitSpecifier: CommitName,
    sourceCommitSpecifier: CommitName,
    mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum,
    conflictDetailLevel: Optional[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = Optional.Absent,
    maxConflictFiles: Optional[MaxResults] = Optional.Absent,
    conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest = {
    import GetMergeConflictsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .mergeOption(mergeOption.unwrap)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(
        maxConflictFiles.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxConflictFiles)
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetMergeConflictsRequest.ReadOnly =
    zio.aws.codecommit.model.GetMergeConflictsRequest.wrap(buildAwsValue())
}
object GetMergeConflictsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetMergeConflictsRequest =
      zio.aws.codecommit.model.GetMergeConflictsRequest(
        repositoryName,
        destinationCommitSpecifier,
        sourceCommitSpecifier,
        mergeOption,
        conflictDetailLevel.map(value => value),
        maxConflictFiles.map(value => value),
        conflictResolutionStrategy.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryName: RepositoryName
    def destinationCommitSpecifier: CommitName
    def sourceCommitSpecifier: CommitName
    def mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum
    def conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def maxConflictFiles: Optional[MaxResults]
    def conflictResolutionStrategy
        : Optional[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def nextToken: Optional[NextToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getMergeOption
        : ZIO[Any, Nothing, zio.aws.codecommit.model.MergeOptionTypeEnum] =
      ZIO.succeed(mergeOption)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getMaxConflictFiles: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxConflictFiles", maxConflictFiles)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest
  ) extends zio.aws.codecommit.model.GetMergeConflictsRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum =
      zio.aws.codecommit.model.MergeOptionTypeEnum.wrap(impl.mergeOption())
    override val conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictDetailLevel())
        .map(value =>
          zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
        )
    override val maxConflictFiles: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxConflictFiles())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
    override val conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictResolutionStrategy())
      .map(value =>
        zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum.wrap(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest
  ): zio.aws.codecommit.model.GetMergeConflictsRequest.ReadOnly = new Wrapper(
    impl
  )
}
