package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PullRequestCreatedEventMetadata(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    sourceCommitId: Optional[CommitId] = Optional.Absent,
    destinationCommitId: Optional[CommitId] = Optional.Absent,
    mergeBase: Optional[CommitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata = {
    import PullRequestCreatedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        sourceCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.sourceCommitId)
      .optionallyWith(
        destinationCommitId.map(value =>
          CommitId.unwrap(value): java.lang.String
        )
      )(_.destinationCommitId)
      .optionallyWith(
        mergeBase.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBase)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.PullRequestCreatedEventMetadata
      .wrap(buildAwsValue())
}
object PullRequestCreatedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequestCreatedEventMetadata =
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata(
        repositoryName.map(value => value),
        sourceCommitId.map(value => value),
        destinationCommitId.map(value => value),
        mergeBase.map(value => value)
      )
    def repositoryName: Optional[RepositoryName]
    def sourceCommitId: Optional[CommitId]
    def destinationCommitId: Optional[CommitId]
    def mergeBase: Optional[CommitId]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getSourceCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("sourceCommitId", sourceCommitId)
    def getDestinationCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("destinationCommitId", destinationCommitId)
    def getMergeBase: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBase", mergeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata
  ) extends zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val sourceCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val destinationCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeBase: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.mergeBase())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestCreatedEventMetadata
  ): zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
