package zio.aws.codecommit.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{Count, Arn}
import scala.jdk.CollectionConverters._
final case class ReactionForComment(
    reaction: Optional[zio.aws.codecommit.model.ReactionValueFormats] =
      Optional.Absent,
    reactionUsers: Optional[Iterable[Arn]] = Optional.Absent,
    reactionsFromDeletedUsersCount: Optional[Count] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ReactionForComment = {
    import ReactionForComment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ReactionForComment
      .builder()
      .optionallyWith(reaction.map(value => value.buildAwsValue()))(_.reaction)
      .optionallyWith(
        reactionUsers.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reactionUsers)
      .optionallyWith(
        reactionsFromDeletedUsersCount.map(value =>
          Count.unwrap(value): Integer
        )
      )(_.reactionsFromDeletedUsersCount)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ReactionForComment.ReadOnly =
    zio.aws.codecommit.model.ReactionForComment.wrap(buildAwsValue())
}
object ReactionForComment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ReactionForComment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ReactionForComment =
      zio.aws.codecommit.model.ReactionForComment(
        reaction.map(value => value.asEditable),
        reactionUsers.map(value => value),
        reactionsFromDeletedUsersCount.map(value => value)
      )
    def reaction
        : Optional[zio.aws.codecommit.model.ReactionValueFormats.ReadOnly]
    def reactionUsers: Optional[List[Arn]]
    def reactionsFromDeletedUsersCount: Optional[Count]
    def getReaction: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ReactionValueFormats.ReadOnly
    ] = AwsError.unwrapOptionField("reaction", reaction)
    def getReactionUsers: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("reactionUsers", reactionUsers)
    def getReactionsFromDeletedUsersCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField(
        "reactionsFromDeletedUsersCount",
        reactionsFromDeletedUsersCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionForComment
  ) extends zio.aws.codecommit.model.ReactionForComment.ReadOnly {
    override val reaction
        : Optional[zio.aws.codecommit.model.ReactionValueFormats.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reaction())
        .map(value => zio.aws.codecommit.model.ReactionValueFormats.wrap(value))
    override val reactionUsers: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.reactionUsers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.Arn(item)
        }.toList
      )
    override val reactionsFromDeletedUsersCount: Optional[Count] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reactionsFromDeletedUsersCount())
        .map(value => zio.aws.codecommit.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionForComment
  ): zio.aws.codecommit.model.ReactionForComment.ReadOnly = new Wrapper(impl)
}
