package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApprovalRuleTemplateResponse(
    approvalRuleTemplateId: ApprovalRuleTemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse = {
    import DeleteApprovalRuleTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse
      .builder()
      .approvalRuleTemplateId(
        ApprovalRuleTemplateId.unwrap(approvalRuleTemplateId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly =
    zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse
      .wrap(buildAwsValue())
}
object DeleteApprovalRuleTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse =
      zio.aws.codecommit.model
        .DeleteApprovalRuleTemplateResponse(approvalRuleTemplateId)
    def approvalRuleTemplateId: ApprovalRuleTemplateId
    def getApprovalRuleTemplateId: ZIO[Any, Nothing, ApprovalRuleTemplateId] =
      ZIO.succeed(approvalRuleTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse
  ) extends zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly {
    override val approvalRuleTemplateId: ApprovalRuleTemplateId =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateId(impl.approvalRuleTemplateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse
  ): zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
