package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PullRequestStatusChangedEventMetadata(
    pullRequestStatus: Optional[
      zio.aws.codecommit.model.PullRequestStatusEnum
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata = {
    import PullRequestStatusChangedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata
      .builder()
      .optionallyWith(pullRequestStatus.map(value => value.unwrap))(
        _.pullRequestStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata
      .wrap(buildAwsValue())
}
object PullRequestStatusChangedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata =
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata(
        pullRequestStatus.map(value => value)
      )
    def pullRequestStatus
        : Optional[zio.aws.codecommit.model.PullRequestStatusEnum]
    def getPullRequestStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestStatusEnum] =
      AwsError.unwrapOptionField("pullRequestStatus", pullRequestStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata
  ) extends zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly {
    override val pullRequestStatus
        : Optional[zio.aws.codecommit.model.PullRequestStatusEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pullRequestStatus())
        .map(value =>
          zio.aws.codecommit.model.PullRequestStatusEnum.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestStatusChangedEventMetadata
  ): zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
