package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{FileContent, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutFileEntry(
    filePath: Path,
    fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] = None,
    fileContent: Option[FileContent] = None,
    sourceFile: Option[zio.aws.codecommit.model.SourceFileSpecifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PutFileEntry = {
    import PutFileEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PutFileEntry
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .optionallyWith(
        fileContent.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.fileContent)
      .optionallyWith(sourceFile.map(value => value.buildAwsValue()))(
        _.sourceFile
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PutFileEntry.ReadOnly =
    zio.aws.codecommit.model.PutFileEntry.wrap(buildAwsValue())
}
object PutFileEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PutFileEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PutFileEntry =
      zio.aws.codecommit.model.PutFileEntry(
        filePath,
        fileMode.map(value => value),
        fileContent.map(value => value),
        sourceFile.map(value => value.asEditable)
      )
    def filePath: Path
    def fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum]
    def fileContent: Option[FileContent]
    def sourceFile
        : Option[zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly]
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
    def getFileContent: ZIO[Any, AwsError, FileContent] =
      AwsError.unwrapOptionField("fileContent", fileContent)
    def getSourceFile: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly
    ] = AwsError.unwrapOptionField("sourceFile", sourceFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileEntry
  ) extends zio.aws.codecommit.model.PutFileEntry.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] =
      scala
        .Option(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
    override val fileContent: Option[FileContent] = scala
      .Option(impl.fileContent())
      .map(value =>
        zio.aws.codecommit.model.primitives
          .FileContent(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val sourceFile
        : Option[zio.aws.codecommit.model.SourceFileSpecifier.ReadOnly] = scala
      .Option(impl.sourceFile())
      .map(value => zio.aws.codecommit.model.SourceFileSpecifier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileEntry
  ): zio.aws.codecommit.model.PutFileEntry.ReadOnly = new Wrapper(impl)
}
