package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetRepositoriesRequest(
    repositoryNames: Iterable[RepositoryName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest = {
    import BatchGetRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest
      .builder()
      .repositoryNames(repositoryNames.map { item =>
        RepositoryName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchGetRepositoriesRequest.ReadOnly =
    zio.aws.codecommit.model.BatchGetRepositoriesRequest.wrap(buildAwsValue())
}
object BatchGetRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetRepositoriesRequest =
      zio.aws.codecommit.model.BatchGetRepositoriesRequest(repositoryNames)
    def repositoryNames: List[RepositoryName]
    def getRepositoryNames: ZIO[Any, Nothing, List[RepositoryName]] =
      ZIO.succeed(repositoryNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest
  ) extends zio.aws.codecommit.model.BatchGetRepositoriesRequest.ReadOnly {
    override val repositoryNames: List[RepositoryName] = impl
      .repositoryNames()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.RepositoryName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest
  ): zio.aws.codecommit.model.BatchGetRepositoriesRequest.ReadOnly =
    new Wrapper(impl)
}
