package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRepositoryResponse(
    repositoryMetadata: Option[zio.aws.codecommit.model.RepositoryMetadata] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse = {
    import CreateRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse
      .builder()
      .optionallyWith(repositoryMetadata.map(value => value.buildAwsValue()))(
        _.repositoryMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly =
    zio.aws.codecommit.model.CreateRepositoryResponse.wrap(buildAwsValue())
}
object CreateRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateRepositoryResponse =
      zio.aws.codecommit.model.CreateRepositoryResponse(
        repositoryMetadata.map(value => value.asEditable)
      )
    def repositoryMetadata
        : Option[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly]
    def getRepositoryMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.RepositoryMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryMetadata", repositoryMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse
  ) extends zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly {
    override val repositoryMetadata
        : Option[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly] = scala
      .Option(impl.repositoryMetadata())
      .map(value => zio.aws.codecommit.model.RepositoryMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse
  ): zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
