package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFileResponse(
    commitId: ObjectId,
    blobId: ObjectId,
    treeId: ObjectId,
    filePath: Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteFileResponse = {
    import DeleteFileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteFileResponse
      .builder()
      .commitId(ObjectId.unwrap(commitId): java.lang.String)
      .blobId(ObjectId.unwrap(blobId): java.lang.String)
      .treeId(ObjectId.unwrap(treeId): java.lang.String)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteFileResponse.ReadOnly =
    zio.aws.codecommit.model.DeleteFileResponse.wrap(buildAwsValue())
}
object DeleteFileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteFileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteFileResponse =
      zio.aws.codecommit.model.DeleteFileResponse(
        commitId,
        blobId,
        treeId,
        filePath
      )
    def commitId: ObjectId
    def blobId: ObjectId
    def treeId: ObjectId
    def filePath: Path
    def getCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(commitId)
    def getBlobId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(blobId)
    def getTreeId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(treeId)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileResponse
  ) extends zio.aws.codecommit.model.DeleteFileResponse.ReadOnly {
    override val commitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.commitId())
    override val blobId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.blobId())
    override val treeId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.treeId())
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteFileResponse
  ): zio.aws.codecommit.model.DeleteFileResponse.ReadOnly = new Wrapper(impl)
}
