package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergePullRequestByFastForwardResponse(
    pullRequest: Option[zio.aws.codecommit.model.PullRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse = {
    import MergePullRequestByFastForwardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse
      .builder()
      .optionallyWith(pullRequest.map(value => value.buildAwsValue()))(
        _.pullRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestByFastForwardResponse
      .wrap(buildAwsValue())
}
object MergePullRequestByFastForwardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.MergePullRequestByFastForwardResponse =
      zio.aws.codecommit.model.MergePullRequestByFastForwardResponse(
        pullRequest.map(value => value.asEditable)
      )
    def pullRequest: Option[zio.aws.codecommit.model.PullRequest.ReadOnly]
    def getPullRequest
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequest.ReadOnly] =
      AwsError.unwrapOptionField("pullRequest", pullRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse
  ) extends zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly {
    override val pullRequest
        : Option[zio.aws.codecommit.model.PullRequest.ReadOnly] = scala
      .Option(impl.pullRequest())
      .map(value => zio.aws.codecommit.model.PullRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse
  ): zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly =
    new Wrapper(impl)
}
