package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  BranchName,
  CommitName,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergeBranchesByFastForwardRequest(
    repositoryName: RepositoryName,
    sourceCommitSpecifier: CommitName,
    destinationCommitSpecifier: CommitName,
    targetBranch: Option[BranchName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest = {
    import MergeBranchesByFastForwardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .optionallyWith(
        targetBranch.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.targetBranch)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergeBranchesByFastForwardRequest.ReadOnly =
    zio.aws.codecommit.model.MergeBranchesByFastForwardRequest
      .wrap(buildAwsValue())
}
object MergeBranchesByFastForwardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeBranchesByFastForwardRequest =
      zio.aws.codecommit.model.MergeBranchesByFastForwardRequest(
        repositoryName,
        sourceCommitSpecifier,
        destinationCommitSpecifier,
        targetBranch.map(value => value)
      )
    def repositoryName: RepositoryName
    def sourceCommitSpecifier: CommitName
    def destinationCommitSpecifier: CommitName
    def targetBranch: Option[BranchName]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getTargetBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("targetBranch", targetBranch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest
  ) extends zio.aws.codecommit.model.MergeBranchesByFastForwardRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val targetBranch: Option[BranchName] = scala
      .Option(impl.targetBranch())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest
  ): zio.aws.codecommit.model.MergeBranchesByFastForwardRequest.ReadOnly =
    new Wrapper(impl)
}
