package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Arn, Overridden}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPullRequestOverrideStateResponse(
    overridden: Option[Overridden] = None,
    overrider: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse = {
    import GetPullRequestOverrideStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
      .builder()
      .optionallyWith(
        overridden.map(value => Overridden.unwrap(value): java.lang.Boolean)
      )(_.overridden)
      .optionallyWith(
        overrider.map(value => Arn.unwrap(value): java.lang.String)
      )(_.overrider)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestOverrideStateResponse
      .wrap(buildAwsValue())
}
object GetPullRequestOverrideStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetPullRequestOverrideStateResponse =
      zio.aws.codecommit.model.GetPullRequestOverrideStateResponse(
        overridden.map(value => value),
        overrider.map(value => value)
      )
    def overridden: Option[Overridden]
    def overrider: Option[Arn]
    def getOverridden: ZIO[Any, AwsError, Overridden] =
      AwsError.unwrapOptionField("overridden", overridden)
    def getOverrider: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("overrider", overrider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ) extends zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly {
    override val overridden: Option[Overridden] = scala
      .Option(impl.overridden())
      .map(value => zio.aws.codecommit.model.primitives.Overridden(value))
    override val overrider: Option[Arn] = scala
      .Option(impl.overrider())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ): zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly =
    new Wrapper(impl)
}
