package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPullRequestApprovalStatesResponse(
    approvals: Option[Iterable[zio.aws.codecommit.model.Approval]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse = {
    import GetPullRequestApprovalStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse
      .builder()
      .optionallyWith(
        approvals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.approvals)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse
      .wrap(buildAwsValue())
}
object GetPullRequestApprovalStatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse =
      zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse(
        approvals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def approvals: Option[List[zio.aws.codecommit.model.Approval.ReadOnly]]
    def getApprovals
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.Approval.ReadOnly]] =
      AwsError.unwrapOptionField("approvals", approvals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse
  ) extends zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly {
    override val approvals
        : Option[List[zio.aws.codecommit.model.Approval.ReadOnly]] = scala
      .Option(impl.approvals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Approval.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse
  ): zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly =
    new Wrapper(impl)
}
