package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{BranchName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBranchRequest(
    repositoryName: Option[RepositoryName] = None,
    branchName: Option[BranchName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetBranchRequest = {
    import GetBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetBranchRequest
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetBranchRequest.ReadOnly =
    zio.aws.codecommit.model.GetBranchRequest.wrap(buildAwsValue())
}
object GetBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetBranchRequest =
      zio.aws.codecommit.model.GetBranchRequest(
        repositoryName.map(value => value),
        branchName.map(value => value)
      )
    def repositoryName: Option[RepositoryName]
    def branchName: Option[BranchName]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetBranchRequest
  ) extends zio.aws.codecommit.model.GetBranchRequest.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val branchName: Option[BranchName] = scala
      .Option(impl.branchName())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetBranchRequest
  ): zio.aws.codecommit.model.GetBranchRequest.ReadOnly = new Wrapper(impl)
}
