package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class File(
    blobId: Option[ObjectId] = None,
    absolutePath: Option[Path] = None,
    relativePath: Option[Path] = None,
    fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.codecommit.model.File = {
    import File.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.File
      .builder()
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        relativePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.relativePath)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.File.ReadOnly =
    zio.aws.codecommit.model.File.wrap(buildAwsValue())
}
object File {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecommit.model.File] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.File =
      zio.aws.codecommit.model.File(
        blobId.map(value => value),
        absolutePath.map(value => value),
        relativePath.map(value => value),
        fileMode.map(value => value)
      )
    def blobId: Option[ObjectId]
    def absolutePath: Option[Path]
    def relativePath: Option[Path]
    def fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum]
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getRelativePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("relativePath", relativePath)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.File
  ) extends zio.aws.codecommit.model.File.ReadOnly {
    override val blobId: Option[ObjectId] = scala
      .Option(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val absolutePath: Option[Path] = scala
      .Option(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val relativePath: Option[Path] = scala
      .Option(impl.relativePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] =
      scala
        .Option(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.File
  ): zio.aws.codecommit.model.File.ReadOnly = new Wrapper(impl)
}
