package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleTemplateDescription,
  ApprovalRuleTemplateContent,
  ApprovalRuleTemplateName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateApprovalRuleTemplateRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    approvalRuleTemplateContent: ApprovalRuleTemplateContent,
    approvalRuleTemplateDescription: Option[ApprovalRuleTemplateDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest = {
    import CreateApprovalRuleTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .approvalRuleTemplateContent(
        ApprovalRuleTemplateContent.unwrap(
          approvalRuleTemplateContent
        ): java.lang.String
      )
      .optionallyWith(
        approvalRuleTemplateDescription.map(value =>
          ApprovalRuleTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest.ReadOnly =
    zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest
      .wrap(buildAwsValue())
}
object CreateApprovalRuleTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest =
      zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest(
        approvalRuleTemplateName,
        approvalRuleTemplateContent,
        approvalRuleTemplateDescription.map(value => value)
      )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def approvalRuleTemplateContent: ApprovalRuleTemplateContent
    def approvalRuleTemplateDescription: Option[ApprovalRuleTemplateDescription]
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getApprovalRuleTemplateContent
        : ZIO[Any, Nothing, ApprovalRuleTemplateContent] =
      ZIO.succeed(approvalRuleTemplateContent)
    def getApprovalRuleTemplateDescription
        : ZIO[Any, AwsError, ApprovalRuleTemplateDescription] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateDescription",
        approvalRuleTemplateDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest
  ) extends zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val approvalRuleTemplateContent: ApprovalRuleTemplateContent =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateContent(impl.approvalRuleTemplateContent())
    override val approvalRuleTemplateDescription
        : Option[ApprovalRuleTemplateDescription] = scala
      .Option(impl.approvalRuleTemplateDescription())
      .map(value =>
        zio.aws.codecommit.model.primitives
          .ApprovalRuleTemplateDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest
  ): zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
