package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Title, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdatePullRequestTitleRequest(
    pullRequestId: PullRequestId,
    title: Title
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest = {
    import UpdatePullRequestTitleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .title(Title.unwrap(title): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdatePullRequestTitleRequest.ReadOnly =
    zio.aws.codecommit.model.UpdatePullRequestTitleRequest.wrap(buildAwsValue())
}
object UpdatePullRequestTitleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdatePullRequestTitleRequest =
      zio.aws.codecommit.model
        .UpdatePullRequestTitleRequest(pullRequestId, title)
    def pullRequestId: PullRequestId
    def title: Title
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getTitle: ZIO[Any, Nothing, Title] = ZIO.succeed(title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest
  ) extends zio.aws.codecommit.model.UpdatePullRequestTitleRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val title: Title =
      zio.aws.codecommit.model.primitives.Title(impl.title())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest
  ): zio.aws.codecommit.model.UpdatePullRequestTitleRequest.ReadOnly =
    new Wrapper(impl)
}
