package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleName,
  Overridden,
  Approved
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Evaluation(
    approved: Option[Approved] = None,
    overridden: Option[Overridden] = None,
    approvalRulesSatisfied: Option[Iterable[ApprovalRuleName]] = None,
    approvalRulesNotSatisfied: Option[Iterable[ApprovalRuleName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Evaluation = {
    import Evaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Evaluation
      .builder()
      .optionallyWith(
        approved.map(value => Approved.unwrap(value): java.lang.Boolean)
      )(_.approved)
      .optionallyWith(
        overridden.map(value => Overridden.unwrap(value): java.lang.Boolean)
      )(_.overridden)
      .optionallyWith(
        approvalRulesSatisfied.map(value =>
          value.map { item =>
            ApprovalRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRulesSatisfied)
      .optionallyWith(
        approvalRulesNotSatisfied.map(value =>
          value.map { item =>
            ApprovalRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRulesNotSatisfied)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Evaluation.ReadOnly =
    zio.aws.codecommit.model.Evaluation.wrap(buildAwsValue())
}
object Evaluation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Evaluation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Evaluation =
      zio.aws.codecommit.model.Evaluation(
        approved.map(value => value),
        overridden.map(value => value),
        approvalRulesSatisfied.map(value => value),
        approvalRulesNotSatisfied.map(value => value)
      )
    def approved: Option[Approved]
    def overridden: Option[Overridden]
    def approvalRulesSatisfied: Option[List[ApprovalRuleName]]
    def approvalRulesNotSatisfied: Option[List[ApprovalRuleName]]
    def getApproved: ZIO[Any, AwsError, Approved] =
      AwsError.unwrapOptionField("approved", approved)
    def getOverridden: ZIO[Any, AwsError, Overridden] =
      AwsError.unwrapOptionField("overridden", overridden)
    def getApprovalRulesSatisfied: ZIO[Any, AwsError, List[ApprovalRuleName]] =
      AwsError.unwrapOptionField(
        "approvalRulesSatisfied",
        approvalRulesSatisfied
      )
    def getApprovalRulesNotSatisfied
        : ZIO[Any, AwsError, List[ApprovalRuleName]] = AwsError
      .unwrapOptionField("approvalRulesNotSatisfied", approvalRulesNotSatisfied)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Evaluation
  ) extends zio.aws.codecommit.model.Evaluation.ReadOnly {
    override val approved: Option[Approved] = scala
      .Option(impl.approved())
      .map(value => zio.aws.codecommit.model.primitives.Approved(value))
    override val overridden: Option[Overridden] = scala
      .Option(impl.overridden())
      .map(value => zio.aws.codecommit.model.primitives.Overridden(value))
    override val approvalRulesSatisfied: Option[List[ApprovalRuleName]] = scala
      .Option(impl.approvalRulesSatisfied())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ApprovalRuleName(item)
        }.toList
      )
    override val approvalRulesNotSatisfied: Option[List[ApprovalRuleName]] =
      scala
        .Option(impl.approvalRulesNotSatisfied())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.ApprovalRuleName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Evaluation
  ): zio.aws.codecommit.model.Evaluation.ReadOnly = new Wrapper(impl)
}
