package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  Arn,
  ApprovalRuleContent,
  LastModifiedDate,
  RuleContentSha256,
  ApprovalRuleId,
  ApprovalRuleName,
  CreationDate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ApprovalRule(
    approvalRuleId: Option[ApprovalRuleId] = None,
    approvalRuleName: Option[ApprovalRuleName] = None,
    approvalRuleContent: Option[ApprovalRuleContent] = None,
    ruleContentSha256: Option[RuleContentSha256] = None,
    lastModifiedDate: Option[LastModifiedDate] = None,
    creationDate: Option[CreationDate] = None,
    lastModifiedUser: Option[Arn] = None,
    originApprovalRuleTemplate: Option[
      zio.aws.codecommit.model.OriginApprovalRuleTemplate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRule = {
    import ApprovalRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRule
      .builder()
      .optionallyWith(
        approvalRuleId.map(value =>
          ApprovalRuleId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleId)
      .optionallyWith(
        approvalRuleName.map(value =>
          ApprovalRuleName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleName)
      .optionallyWith(
        approvalRuleContent.map(value =>
          ApprovalRuleContent.unwrap(value): java.lang.String
        )
      )(_.approvalRuleContent)
      .optionallyWith(
        ruleContentSha256.map(value =>
          RuleContentSha256.unwrap(value): java.lang.String
        )
      )(_.ruleContentSha256)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedUser.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastModifiedUser)
      .optionallyWith(
        originApprovalRuleTemplate.map(value => value.buildAwsValue())
      )(_.originApprovalRuleTemplate)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ApprovalRule.ReadOnly =
    zio.aws.codecommit.model.ApprovalRule.wrap(buildAwsValue())
}
object ApprovalRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalRule =
      zio.aws.codecommit.model.ApprovalRule(
        approvalRuleId.map(value => value),
        approvalRuleName.map(value => value),
        approvalRuleContent.map(value => value),
        ruleContentSha256.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        lastModifiedUser.map(value => value),
        originApprovalRuleTemplate.map(value => value.asEditable)
      )
    def approvalRuleId: Option[ApprovalRuleId]
    def approvalRuleName: Option[ApprovalRuleName]
    def approvalRuleContent: Option[ApprovalRuleContent]
    def ruleContentSha256: Option[RuleContentSha256]
    def lastModifiedDate: Option[LastModifiedDate]
    def creationDate: Option[CreationDate]
    def lastModifiedUser: Option[Arn]
    def originApprovalRuleTemplate
        : Option[zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly]
    def getApprovalRuleId: ZIO[Any, AwsError, ApprovalRuleId] =
      AwsError.unwrapOptionField("approvalRuleId", approvalRuleId)
    def getApprovalRuleName: ZIO[Any, AwsError, ApprovalRuleName] =
      AwsError.unwrapOptionField("approvalRuleName", approvalRuleName)
    def getApprovalRuleContent: ZIO[Any, AwsError, ApprovalRuleContent] =
      AwsError.unwrapOptionField("approvalRuleContent", approvalRuleContent)
    def getRuleContentSha256: ZIO[Any, AwsError, RuleContentSha256] =
      AwsError.unwrapOptionField("ruleContentSha256", ruleContentSha256)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedUser: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getOriginApprovalRuleTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originApprovalRuleTemplate",
      originApprovalRuleTemplate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRule
  ) extends zio.aws.codecommit.model.ApprovalRule.ReadOnly {
    override val approvalRuleId: Option[ApprovalRuleId] = scala
      .Option(impl.approvalRuleId())
      .map(value => zio.aws.codecommit.model.primitives.ApprovalRuleId(value))
    override val approvalRuleName: Option[ApprovalRuleName] = scala
      .Option(impl.approvalRuleName())
      .map(value => zio.aws.codecommit.model.primitives.ApprovalRuleName(value))
    override val approvalRuleContent: Option[ApprovalRuleContent] = scala
      .Option(impl.approvalRuleContent())
      .map(value =>
        zio.aws.codecommit.model.primitives.ApprovalRuleContent(value)
      )
    override val ruleContentSha256: Option[RuleContentSha256] = scala
      .Option(impl.ruleContentSha256())
      .map(value =>
        zio.aws.codecommit.model.primitives.RuleContentSha256(value)
      )
    override val lastModifiedDate: Option[LastModifiedDate] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.codecommit.model.primitives.LastModifiedDate(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val lastModifiedUser: Option[Arn] = scala
      .Option(impl.lastModifiedUser())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val originApprovalRuleTemplate
        : Option[zio.aws.codecommit.model.OriginApprovalRuleTemplate.ReadOnly] =
      scala
        .Option(impl.originApprovalRuleTemplate())
        .map(value =>
          zio.aws.codecommit.model.OriginApprovalRuleTemplate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRule
  ): zio.aws.codecommit.model.ApprovalRule.ReadOnly = new Wrapper(impl)
}
