package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FileMetadata(
    absolutePath: Option[Path] = None,
    blobId: Option[ObjectId] = None,
    fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.FileMetadata = {
    import FileMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.FileMetadata
      .builder()
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.FileMetadata.ReadOnly =
    zio.aws.codecommit.model.FileMetadata.wrap(buildAwsValue())
}
object FileMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.FileMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.FileMetadata =
      zio.aws.codecommit.model.FileMetadata(
        absolutePath.map(value => value),
        blobId.map(value => value),
        fileMode.map(value => value)
      )
    def absolutePath: Option[Path]
    def blobId: Option[ObjectId]
    def fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum]
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.FileMetadata
  ) extends zio.aws.codecommit.model.FileMetadata.ReadOnly {
    override val absolutePath: Option[Path] = scala
      .Option(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val blobId: Option[ObjectId] = scala
      .Option(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] =
      scala
        .Option(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.FileMetadata
  ): zio.aws.codecommit.model.FileMetadata.ReadOnly = new Wrapper(impl)
}
