package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  Arn,
  RepositoryName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPullRequestsRequest(
    repositoryName: RepositoryName,
    authorArn: Option[Arn] = None,
    pullRequestStatus: Option[zio.aws.codecommit.model.PullRequestStatusEnum] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest = {
    import ListPullRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        authorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.authorArn)
      .optionallyWith(pullRequestStatus.map(value => value.unwrap))(
        _.pullRequestStatus
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListPullRequestsRequest.ReadOnly =
    zio.aws.codecommit.model.ListPullRequestsRequest.wrap(buildAwsValue())
}
object ListPullRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListPullRequestsRequest =
      zio.aws.codecommit.model.ListPullRequestsRequest(
        repositoryName,
        authorArn.map(value => value),
        pullRequestStatus.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def repositoryName: RepositoryName
    def authorArn: Option[Arn]
    def pullRequestStatus
        : Option[zio.aws.codecommit.model.PullRequestStatusEnum]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getAuthorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("authorArn", authorArn)
    def getPullRequestStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestStatusEnum] =
      AwsError.unwrapOptionField("pullRequestStatus", pullRequestStatus)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest
  ) extends zio.aws.codecommit.model.ListPullRequestsRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val authorArn: Option[Arn] = scala
      .Option(impl.authorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val pullRequestStatus
        : Option[zio.aws.codecommit.model.PullRequestStatusEnum] = scala
      .Option(impl.pullRequestStatus())
      .map(value => zio.aws.codecommit.model.PullRequestStatusEnum.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest
  ): zio.aws.codecommit.model.ListPullRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
