package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDescribeMergeConflictsResponse(
    conflicts: Iterable[zio.aws.codecommit.model.Conflict],
    nextToken: Option[NextToken] = None,
    errors: Option[
      Iterable[zio.aws.codecommit.model.BatchDescribeMergeConflictsError]
    ] = None,
    destinationCommitId: ObjectId,
    sourceCommitId: ObjectId,
    baseCommitId: Option[ObjectId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse = {
    import BatchDescribeMergeConflictsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse
      .builder()
      .conflicts(conflicts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .destinationCommitId(
        ObjectId.unwrap(destinationCommitId): java.lang.String
      )
      .sourceCommitId(ObjectId.unwrap(sourceCommitId): java.lang.String)
      .optionallyWith(
        baseCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.baseCommitId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly =
    zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse
      .wrap(buildAwsValue())
}
object BatchDescribeMergeConflictsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse =
      zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse(
        conflicts.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationCommitId,
        sourceCommitId,
        baseCommitId.map(value => value)
      )
    def conflicts: List[zio.aws.codecommit.model.Conflict.ReadOnly]
    def nextToken: Option[NextToken]
    def errors: Option[
      List[zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly]
    ]
    def destinationCommitId: ObjectId
    def sourceCommitId: ObjectId
    def baseCommitId: Option[ObjectId]
    def getConflicts
        : ZIO[Any, Nothing, List[zio.aws.codecommit.model.Conflict.ReadOnly]] =
      ZIO.succeed(conflicts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getDestinationCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(destinationCommitId)
    def getSourceCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(sourceCommitId)
    def getBaseCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("baseCommitId", baseCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse
  ) extends zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly {
    override val conflicts: List[zio.aws.codecommit.model.Conflict.ReadOnly] =
      impl
        .conflicts()
        .asScala
        .map { item =>
          zio.aws.codecommit.model.Conflict.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val errors: Option[
      List[zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.BatchDescribeMergeConflictsError.wrap(item)
        }.toList
      )
    override val destinationCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.destinationCommitId())
    override val sourceCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.sourceCommitId())
    override val baseCommitId: Option[ObjectId] = scala
      .Option(impl.baseCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse
  ): zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly =
    new Wrapper(impl)
}
