package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, ObjectId, IsMergeable}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMergeConflictsResponse(
    mergeable: IsMergeable,
    destinationCommitId: ObjectId,
    sourceCommitId: ObjectId,
    baseCommitId: Option[ObjectId] = None,
    conflictMetadataList: Iterable[zio.aws.codecommit.model.ConflictMetadata],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse = {
    import GetMergeConflictsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse
      .builder()
      .mergeable(IsMergeable.unwrap(mergeable): java.lang.Boolean)
      .destinationCommitId(
        ObjectId.unwrap(destinationCommitId): java.lang.String
      )
      .sourceCommitId(ObjectId.unwrap(sourceCommitId): java.lang.String)
      .optionallyWith(
        baseCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.baseCommitId)
      .conflictMetadataList(conflictMetadataList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly =
    zio.aws.codecommit.model.GetMergeConflictsResponse.wrap(buildAwsValue())
}
object GetMergeConflictsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetMergeConflictsResponse =
      zio.aws.codecommit.model.GetMergeConflictsResponse(
        mergeable,
        destinationCommitId,
        sourceCommitId,
        baseCommitId.map(value => value),
        conflictMetadataList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def mergeable: IsMergeable
    def destinationCommitId: ObjectId
    def sourceCommitId: ObjectId
    def baseCommitId: Option[ObjectId]
    def conflictMetadataList
        : List[zio.aws.codecommit.model.ConflictMetadata.ReadOnly]
    def nextToken: Option[NextToken]
    def getMergeable: ZIO[Any, Nothing, IsMergeable] = ZIO.succeed(mergeable)
    def getDestinationCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(destinationCommitId)
    def getSourceCommitId: ZIO[Any, Nothing, ObjectId] =
      ZIO.succeed(sourceCommitId)
    def getBaseCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("baseCommitId", baseCommitId)
    def getConflictMetadataList: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.ConflictMetadata.ReadOnly
    ]] = ZIO.succeed(conflictMetadataList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse
  ) extends zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly {
    override val mergeable: IsMergeable =
      zio.aws.codecommit.model.primitives.IsMergeable(impl.mergeable())
    override val destinationCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.destinationCommitId())
    override val sourceCommitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.sourceCommitId())
    override val baseCommitId: Option[ObjectId] = scala
      .Option(impl.baseCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val conflictMetadataList
        : List[zio.aws.codecommit.model.ConflictMetadata.ReadOnly] = impl
      .conflictMetadataList()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.ConflictMetadata.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse
  ): zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly = new Wrapper(
    impl
  )
}
