package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitId, Arn, IsMerged}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergeMetadata(
    isMerged: Option[IsMerged] = None,
    mergedBy: Option[Arn] = None,
    mergeCommitId: Option[CommitId] = None,
    mergeOption: Option[zio.aws.codecommit.model.MergeOptionTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeMetadata = {
    import MergeMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeMetadata
      .builder()
      .optionallyWith(
        isMerged.map(value => IsMerged.unwrap(value): java.lang.Boolean)
      )(_.isMerged)
      .optionallyWith(
        mergedBy.map(value => Arn.unwrap(value): java.lang.String)
      )(_.mergedBy)
      .optionallyWith(
        mergeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeCommitId)
      .optionallyWith(mergeOption.map(value => value.unwrap))(_.mergeOption)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.MergeMetadata.ReadOnly =
    zio.aws.codecommit.model.MergeMetadata.wrap(buildAwsValue())
}
object MergeMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeMetadata =
      zio.aws.codecommit.model.MergeMetadata(
        isMerged.map(value => value),
        mergedBy.map(value => value),
        mergeCommitId.map(value => value),
        mergeOption.map(value => value)
      )
    def isMerged: Option[IsMerged]
    def mergedBy: Option[Arn]
    def mergeCommitId: Option[CommitId]
    def mergeOption: Option[zio.aws.codecommit.model.MergeOptionTypeEnum]
    def getIsMerged: ZIO[Any, AwsError, IsMerged] =
      AwsError.unwrapOptionField("isMerged", isMerged)
    def getMergedBy: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("mergedBy", mergedBy)
    def getMergeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeCommitId", mergeCommitId)
    def getMergeOption
        : ZIO[Any, AwsError, zio.aws.codecommit.model.MergeOptionTypeEnum] =
      AwsError.unwrapOptionField("mergeOption", mergeOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeMetadata
  ) extends zio.aws.codecommit.model.MergeMetadata.ReadOnly {
    override val isMerged: Option[IsMerged] = scala
      .Option(impl.isMerged())
      .map(value => zio.aws.codecommit.model.primitives.IsMerged(value))
    override val mergedBy: Option[Arn] = scala
      .Option(impl.mergedBy())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val mergeCommitId: Option[CommitId] = scala
      .Option(impl.mergeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeOption
        : Option[zio.aws.codecommit.model.MergeOptionTypeEnum] = scala
      .Option(impl.mergeOption())
      .map(value => zio.aws.codecommit.model.MergeOptionTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeMetadata
  ): zio.aws.codecommit.model.MergeMetadata.ReadOnly = new Wrapper(impl)
}
