package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CommentsForComparedCommit(
    repositoryName: Option[RepositoryName] = None,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: Option[CommitId] = None,
    beforeBlobId: Option[ObjectId] = None,
    afterBlobId: Option[ObjectId] = None,
    location: Option[zio.aws.codecommit.model.Location] = None,
    comments: Option[Iterable[zio.aws.codecommit.model.Comment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CommentsForComparedCommit = {
    import CommentsForComparedCommit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CommentsForComparedCommit
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        beforeBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.beforeBlobId)
      .optionallyWith(
        afterBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.afterBlobId)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        comments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comments)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly =
    zio.aws.codecommit.model.CommentsForComparedCommit.wrap(buildAwsValue())
}
object CommentsForComparedCommit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CommentsForComparedCommit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CommentsForComparedCommit =
      zio.aws.codecommit.model.CommentsForComparedCommit(
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        beforeBlobId.map(value => value),
        afterBlobId.map(value => value),
        location.map(value => value.asEditable),
        comments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def repositoryName: Option[RepositoryName]
    def beforeCommitId: Option[CommitId]
    def afterCommitId: Option[CommitId]
    def beforeBlobId: Option[ObjectId]
    def afterBlobId: Option[ObjectId]
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def comments: Option[List[zio.aws.codecommit.model.Comment.ReadOnly]]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getBeforeBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("beforeBlobId", beforeBlobId)
    def getAfterBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("afterBlobId", afterBlobId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getComments
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.Comment.ReadOnly]] =
      AwsError.unwrapOptionField("comments", comments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CommentsForComparedCommit
  ) extends zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Option[CommitId] = scala
      .Option(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val beforeBlobId: Option[ObjectId] = scala
      .Option(impl.beforeBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val afterBlobId: Option[ObjectId] = scala
      .Option(impl.afterBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val comments
        : Option[List[zio.aws.codecommit.model.Comment.ReadOnly]] = scala
      .Option(impl.comments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Comment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CommentsForComparedCommit
  ): zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly = new Wrapper(
    impl
  )
}
