package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMergeCommitResponse(
    sourceCommitId: Option[ObjectId] = None,
    destinationCommitId: Option[ObjectId] = None,
    baseCommitId: Option[ObjectId] = None,
    mergedCommitId: Option[ObjectId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse = {
    import GetMergeCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse
      .builder()
      .optionallyWith(
        sourceCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.sourceCommitId)
      .optionallyWith(
        destinationCommitId.map(value =>
          ObjectId.unwrap(value): java.lang.String
        )
      )(_.destinationCommitId)
      .optionallyWith(
        baseCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.baseCommitId)
      .optionallyWith(
        mergedCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.mergedCommitId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly =
    zio.aws.codecommit.model.GetMergeCommitResponse.wrap(buildAwsValue())
}
object GetMergeCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetMergeCommitResponse =
      zio.aws.codecommit.model.GetMergeCommitResponse(
        sourceCommitId.map(value => value),
        destinationCommitId.map(value => value),
        baseCommitId.map(value => value),
        mergedCommitId.map(value => value)
      )
    def sourceCommitId: Option[ObjectId]
    def destinationCommitId: Option[ObjectId]
    def baseCommitId: Option[ObjectId]
    def mergedCommitId: Option[ObjectId]
    def getSourceCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("sourceCommitId", sourceCommitId)
    def getDestinationCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("destinationCommitId", destinationCommitId)
    def getBaseCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("baseCommitId", baseCommitId)
    def getMergedCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("mergedCommitId", mergedCommitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse
  ) extends zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly {
    override val sourceCommitId: Option[ObjectId] = scala
      .Option(impl.sourceCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val destinationCommitId: Option[ObjectId] = scala
      .Option(impl.destinationCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val baseCommitId: Option[ObjectId] = scala
      .Option(impl.baseCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val mergedCommitId: Option[ObjectId] = scala
      .Option(impl.mergedCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse
  ): zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly = new Wrapper(
    impl
  )
}
